% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estim_raw.R
\name{estim_raw}
\alias{estim_raw}
\title{Estimation of Four-Fold (2x2) Table Cell Frequencies (Raw Data) from Effect Size Measures}
\usage{
estim_raw(es, lb, ub, m1, m2, e1, dec = 1, measure = c("or", "rd", "rr"))
}
\arguments{
\item{es}{Value of the effect size (summary statistic).}

\item{lb}{Lower bound of the 95\% confidence interval of the effect size.}

\item{ub}{Upper bound of the 95\% confidence interval of the effect size.}

\item{m1}{Total number of participants in the exposed/treated group.}

\item{m2}{Total number of participants in the unexposed/control group.}

\item{e1}{Total number of participants developing the outcome event (optional).}

\item{dec}{Number of decimal places with which effect sizes are being presented.}

\item{measure}{Character string indicating the type of effect size measure. Possible options are the risk ratio/relative risk ("rr"), the risk difference ("rd"), and the odds ratio ("or").}
}
\value{
\enumerate{
\item Estimates from risk ratios: A dataframe. If there is information on the number of participants developing the outcome event (e1), this dataframe will list all sets of results in which a+c=e1. If no such information is provided, this dataframe will list a point estimate for each cell (calculated based on the exact input values), as well as minimum and a maximum estimate.
\item Estimates from risk differences: A list consisting of two dataframes - solution1 (presenting the results of the first solution of the quadratic formula) and solution2 (presenting the results of the second solution of the quadratic formula). If there is information on the number of participants developing the outcome event (e1), each of these dataframes will list all sets of results in which a+c=e1. If no such information is provided, each of these dataframes will list a point estimate for each cell (calculated based on the exact input values), as well as minimum and a maximum estimate.
}
}
\description{
Estimation of four-fold (2x2) table cell frequencies (raw data) from risk ratios (relative risks), risk differences and odds ratios.
}
\examples{

estim_rr <- estim_raw(es=0.6,lb=0.4,ub=0.9,m1=352,m2=376,dec=1,measure="rr")
estim_rr

estim_or1 <- estim_raw(es=0.6207,lb=0.3382,ub=1.1391,m1=355,m2=366,dec=4,measure="or")
estim_or1

estim_or2 <- estim_raw(es=0.6,lb=0.3,ub=1.1,m1=355,m2=366,e1=47,dec=1,measure="or")
estim_or2

estim_rd <- estim_raw(es=-0.0783,lb=-0.1387,ub=-0.018,m1=373,m2=357,e1=163,dec=4,measure="rd")
estim_rd

}
