% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trading.R
\name{etrd_place_optn_order}
\alias{etrd_place_optn_order}
\title{Place an Option Order}
\usage{
etrd_place_optn_order(
  account,
  symbol,
  callPut,
  expiryYear,
  expiryMonth,
  expiryDay,
  strikePrice,
  quantity,
  orderAction,
  priceType,
  stopPrice = "",
  limitPrice = "",
  stopLimitPrice = "",
  quantityType = "quantity",
  orderTerm = "good_for_day",
  marketSession = "regular",
  allOrNone = "false",
  previewOrder = "df",
  etrade_cred = NULL,
  access_tokens = NULL,
  sandbox = FALSE
)
}
\arguments{
\item{account}{The account ID key, not the account ID associated with the
specific account. Use \code{\link{etrd_account_list}} to identify the
proper account id key.}

\item{symbol}{The market symbol for the security being bought or sold}

\item{callPut}{The option type:    CALL, PUT}

\item{expiryYear}{The four-digit year the option will expire}

\item{expiryMonth}{The month (1-12) the option will expire}

\item{expiryDay}{The day (1-31) the option will expire}

\item{strikePrice}{The strike price for the option}

\item{quantity}{The number of shares to buy or sell}

\item{orderAction}{The action that the broker is requested to perform:
BUY_OPEN, BUY_CLOSE, SELL_OPEN, SELL_CLOSE}

\item{priceType}{The type of pricing: MARKET, LIMIT, STOP, STOP_LIMIT,
TRAILING_STOP_CNST, TRAILING_STOP_PRCT, MARKET_ON_OPEN, MARKET_ON_CLOSE,
LIMIT_ON_OPEN, LIMIT_ON_CLOSE}

\item{stopPrice}{The designated boundary price for a stop order. For trailing
stop orders this will represent the dollar amount or percentage trailing
value. Enter percentages as whole numbers.}

\item{limitPrice}{The highest price at which to buy or the lowest price at
which to sell if specified in a limit order}

\item{stopLimitPrice}{The designated boundary price for a stop-limit order}

\item{quantityType}{The type of the quantity - QUANTITY, DOLLAR, ALL_I_OWN
(note: DOLLAR is not yet an option)}

\item{orderTerm}{The term for which the order is in effect:
GOOD_UNTIL_CANCEL, GOOD_FOR_DAY, IMMEDIATE_OR_CANCEL, FILL_OR_KILL}

\item{marketSession}{The session in which the order will be placed: REGULAR,
EXTENDED}

\item{allOrNone}{If TRUE, the transactions specified in the order must be
executed all at once or not at all; default is FALSE}

\item{previewOrder}{Elect to preview the order before submitting.  Options
are: 'df', 'json', or 'none' for an instant order entry. In a non
interactive environment will default to 'none'. This also indicates how the
order output is shown. json will return the output as a list, otherwise it
will return as a dataframe}

\item{etrade_cred}{The output created from
\code{\link{etrd_auth_credentials}} when a valid ETRADE key and secret have
been passed. This entry is not required because the output is saved and
retrieved from R options automatically.}

\item{access_tokens}{Access tokens are created using
\code{\link{etrd_auth_access_token}}. This entry is not required because
the output is saved and retrieved from R options automatically.}

\item{sandbox}{ETRADE offers a sandbox environment for validating API calls
and responses. If using the sandbox environment, this must be set to TRUE
in each function called throughout etrader. ETRADE states "Sandbox
responses use stored data that's intended to provide typical responses for
basic use cases. So the responses you receive will not contain current
data, and may not exactly match your requests in other ways." Essentially,
the responses will not match the requests entered but successful pull will
indicate whether the entry was valid or not.}
}
\value{
A list or data frame of the order entry details
}
\description{
Execute an option order on the ETrade platform for the selected account.
Users are given the option to preview the order before submitting. Note:
ETrade offers significantly more complex order structures than what is
offered in this function. See the
\href{https://apisb.etrade.com/docs/api/order/api-order-v1.html#}{ETrade
documentation} for more details on submitting complex option strategies.
}
\section{Warning}{
 TRADES THAT ARE SUCCESSFULLY ENTERED WILL BE SENT FOR
  EXECUTION. THIS FUNCTION HAS HUNDREDS OF POTENTIAL COMBINATIONS AND ONLY A
  HANDFUL HAVE BEEN TESTED. IT IS STRONGLY RECOMMENDED TO TEST THE DESIRED
  ORDER USING THE SANDBOX ENVIRONMENT. PLEASE NOTE THE SANDBOX ENVIRONMENT
  WILL NOT RETURN THE ORDER ENTERED, IT IS USED FOR CONFIRMING THE ORDER
  ENTRY HAS CORRECT SYNTAX. ORDERS CAN ALSO BE TESTED IN OFF MARKET HOURS ON
  A VERY SMALL QUANTITY WITH LITTLE MONEY AT STAKE. ANOTHER OPTION IS TO USE
  LIMIT ORDERS FAR FROM THE CURRENT PRICE. ETRADE HAS THEIR OWN ERROR
  HANDLING BUT IF A SUCCESSFUL COMBINATION IS ENTERED IT COULD BE EXECUTED
  UNINTENTIONALLY. DOUBLE CHECK ALL ENTRIES BEFORE SUBMITTING.
}

\examples{
\dontrun{

# Place Option Buy_to_open order
acts = etrd_account_list()
account = acts$accountIdKey[1]
etrd_place_optn_order(account = account,
                      symbol = 'FB',
                      callPut = 'call',
                      expiryYear = '2018',
                      expiryMonth = '12',
                      expiryDay  = '21',
                      strikePrice = '140',
                      quantity = 1,
                      orderAction = 'BUY_OPEN',
                      priceType = 'market',
                      previewOrder = 'df')

}
}
