% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strategy_classes.R
\name{plot,GenericStrat-method}
\alias{plot,GenericStrat-method}
\title{S4 method for the plot generic for portfolio insurance strategy classes}
\usage{
\S4method{plot}{GenericStrat}(
  x,
  y = NULL,
  title = "Strategy plot",
  xlab = "",
  ylab.1 = "Price",
  ylab.2 = "Hedge \%",
  pcols = c("#F8766D", "steelblue3", "gray60", "gray80"),
  legend = "bottom"
)
}
\arguments{
\item{x}{instance of the strategy class created by the corresponding strategy function}

\item{y}{NULL}

\item{title}{plot title}

\item{xlab}{label for x-axis}

\item{ylab.1}{label for y-axis on price plot in top panel}

\item{ylab.2}{label for y-axis on hedge plot in bottom panel}

\item{pcols}{vector with four color codes for plot}

\item{legend}{legend position in c("top", "bottom")}
}
\value{
a two-panel chart with daily values for (top panel) target price,
market price and portfolio price and (bottom) portfolio hedge rate
}
\description{
S4 method for the plot generic for portfolio insurance strategy classes
}
