% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_diag_control.R
\name{create_diag_control}
\alias{create_diag_control}
\title{Data analysis for diagnostic samples during the control phase}
\usage{
create_diag_control(
  herd_summary,
  farm_summary,
  par_diag_control_ffd_prev,
  par_diag_control_ffd_certainty,
  par_diag_control_edta,
  par_diag_control_serum,
  par_diag_control_bulk_milk,
  par_diag_control_lesions_smrum,
  par_diag_control_lesions_pigs,
  par_diag_control_lesions_cattle,
  rel_cols_farm_summary_dc,
  rel_cols_herd_summary_dc,
  herd_types_dairy,
  herd_types_small_ruminants,
  herd_types_pigs,
  herd_types_cattle
)
}
\arguments{
\item{herd_summary}{Data frame; EuFMDIS output file "Herd summary"}

\item{farm_summary}{Data frame; EuFMDIS output file "Farm summary"}

\item{par_diag_control_ffd_prev}{numeric between 0 and 100; design
prevalence for the computation of the sample size according to freedom from
disease}

\item{par_diag_control_ffd_certainty}{numeric between 0 and 100; desired
accuracy for the computation of the sample size according to freedom from
disease}

\item{par_diag_control_edta}{positive integer; Number of blood samples (EDTA)
per symptomatic suspect holding}

\item{par_diag_control_serum}{positive integer; Number of blood samples
(serum) per symptomatic suspect holding}

\item{par_diag_control_bulk_milk}{positive integer; Number of bulk milk
samples per dairy farm}

\item{par_diag_control_lesions_smrum}{positive integer; Number of acute
lesion samples for small ruminants per farm}

\item{par_diag_control_lesions_pigs}{positive integer; Number of acute
lesion samples for pigs per farm}

\item{par_diag_control_lesions_cattle}{positive integer; Number of acute
lesion samples for cattle per farm}

\item{rel_cols_farm_summary_dc}{character vector of column names of the
data frame \code{farm_summary} that are required for the analysis}

\item{rel_cols_herd_summary_dc}{character vector of column names of the
data frame \code{herd_summary} that are required for the analysis}

\item{herd_types_dairy}{character vector listing the different herd types
that are associated with dairy herds}

\item{herd_types_small_ruminants}{character vector listing the different
herd types that are associated with small ruminant herds}

\item{herd_types_pigs}{character vector listing the different herd types
that are associated with pig herds}

\item{herd_types_cattle}{character vector listing the different herd types
that are associated with cattle herds}
}
\value{
Returns an aggregated data frame with one line per simulation run.
The data frame contains auxilliary variables needed to appriximate the
number of diagnostic samples required during the control phase as well as
the estimated values for number of bulk milk samples (n_bulk_milk), acute
lesions (n_acute_lesion), swabs (n_swabs), blood samples for edta analysis
(n_blood_edta) and serum analysis (n_blood_serum).
}
\description{
Function to perform the data analysis, necessary for the analysis of the
diagnostic samples during the control phase
}
\details{
This function is used internally to prepare the input data for the output
(tables and plots) in the sub menu "Diagnostic tests control phase" of the
ADAPT App.
}
