% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-competition-calendar.R
\name{getCompetitionCalendar}
\alias{getCompetitionCalendar}
\title{Get competition calendar standings}
\usage{
getCompetitionCalendar(season_code, round)
}
\arguments{
\item{season_code}{One or more season codes as obtained from \code{\link[=getCompetitionHistory]{getCompetitionHistory()}}.\cr
Examples are \code{E2023} for Euroleague or \code{U2023} for Eurocup 2023.}

\item{round}{One or more round codes as obtained from \code{\link[=getCompetitionRounds]{getCompetitionRounds()}}.}
}
\value{
Returns a summary tibble of calendar standings for chosen competitions
and rounds

Reference webpage: \href{https://www.euroleaguebasketball.net/euroleague/standings/?season=2023-24&type=Calendar&phase=REGULAR\%20SEASON}{Calendar standings}
}
\description{
Get competition calendar standings
}
\examples{

if(interactive()) {

getCompetitionCalendar(season_code = c("E2023", "E2022"), round = 1)

}

}
\keyword{`r}
\keyword{competitionStandings}
\keyword{lifecycle::badge('experimental')`}
