% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-player-points.R
\name{getPlayerPoints}
\alias{getPlayerPoints}
\title{Get player points statistics}
\usage{
getPlayerPoints(season_code)
}
\arguments{
\item{season_code}{One or more season codes as obtained from \code{\link[=getCompetitionHistory]{getCompetitionHistory()}}.\cr
Examples are \code{E2023} for Euroleague or \code{U2023} for Eurocup 2023.}
}
\value{
Returns a summary tibble of points players statistics for chosen seasons.

Glossary of columns:\tabular{lll}{
   \strong{Column name} \tab \strong{Column extended name} \tab \strong{Column description} \cr
   2PA-S \tab Two-point attempts share \tab Player's share of team's total two-point attempts \cr
   3PA-S \tab Three-point attempts share \tab Player's share of team's total three-point attempts \cr
   FTA-S \tab Free throw attempts share \tab Player's share of team's total free throw attempts \cr
   2PM-S \tab Two-pointers made share \tab Player's share of team's total two-pointers made \cr
   3PM-S \tab Three-pointers made share \tab Player's share of team's total three-pointers made \cr
   FTM-S \tab Free throws made share \tab Player's share of team's total free throws made \cr
   2P-RT \tab Two-Point Rate \tab \% of a player's field goal attempts that are two-pointers \cr
   3P-RT \tab Three-Point Rate \tab \% of field goal attempts that are three-pointers \cr
   \%2P \tab \% of points from two-pointers \tab \% of points from two-point shots made \cr
   \%3P \tab \% of points from three-pointers \tab \% of points from three-point shots made \cr
   \%FT \tab \% of points from free throws \tab \% of points from free throws made \cr
}


Reference webpage: \href{https://www.euroleaguebasketball.net/euroleague/stats/expanded/?size=1000&viewType=scoring&seasonCode=E2023&statisticMode=perGame&seasonMode=Single&sortDirection=descending&statistic=fieldGoals2Percent}{Stats}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{

\dontrun{

getPlayerPoints(season_code = "E2023")

}

}
