% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrlPlot.R
\name{mrlPlot}
\alias{mrlPlot}
\title{Mean Residual Life Plot for the Generalized Pareto Distribution}
\usage{
mrlPlot(data, thresholds = NULL, conf = 0.95, npoints = 100)
}
\arguments{
\item{data}{Vector of data.}

\item{thresholds}{A numeric vector of threshold(s) to plot vertically. Defaults to NULL.}

\item{conf}{The level of the confidence bounds to use. Defaults to 0.95.}

\item{npoints}{The number of points to interpolate with. Defaults to 100.}
}
\description{
Plots the empirical mean residual life, with confidence intervals. The mean residual life plot provides a
visual diagnostic tool to choose a threshold for exceedances.
}
\examples{
\donttest{
x <- rgpd(500, loc = 0, scale = 1, shape = 0.1)
mrlPlot(x, thresholds = c(2))
}
}
