% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_column.R
\name{map_column}
\alias{map_column}
\title{map_column(): Map values in a column using named vector or list}
\usage{
map_column(
  query,
  by,
  map,
  to = "mapped",
  overwrite = FALSE,
  default = "unknown",
  preview = TRUE
)
}
\arguments{
\item{query}{A data.frame containing the column to be mapped.}

\item{by}{A string. Column name in \code{query} to be mapped.}

\item{map}{A named vector or list. Names are original values, values are mapped values.}

\item{to}{A string. Name of the column to store mapped results (if \code{overwrite = FALSE}).}

\item{overwrite}{Logical. Whether to replace the \code{by} column with mapped values. Default: FALSE.}

\item{default}{Default value to assign if no match is found. Default: "unknown".}

\item{preview}{Logical. Whether to print preview of result (default TRUE).}
}
\value{
A data.frame with a new or modified column based on the mapping (returned invisibly).
}
\description{
Maps values in a column of a data.frame (query) to new values using a named
vector or list (\code{map}), optionally creating a new column or replacing the original.
}
\examples{
df <- data.frame(gene = c("TP53", "BRCA1", "EGFR", "XYZ"))
gene_map <- c("TP53" = "Tumor suppressor", "EGFR" = "Oncogene")
map_column(df, by = "gene", map = gene_map, to = "label")
}
