% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulateTree.R
\name{simulateTree}
\alias{simulateTree}
\title{Simulating a phylogenetic trees through the birth-death process}
\usage{
simulateTree(
  pars,
  max.taxa = Inf,
  max.t,
  min.taxa = 2,
  include.extinct = FALSE
)
}
\arguments{
\item{pars}{\code{numeric} vector with the simulation parameters: speciation
(first slot) and extinction (second slot) rates, respectively. Should follow
any formats stated in the function \code{tree.bd} from the
\code{diversitree} package.}

\item{max.taxa}{Maximum number of taxa to include in the tree. If
\code{Inf}, then the tree will be evolved until \code{max.t} time has passed.}

\item{max.t}{Maximum length to evolve the phylogeny over. If equal to
\code{Inf}, then the tree will evolve until \code{max.taxa}
extant taxa are present.}

\item{min.taxa}{Minimum number of taxa to include in the tree.}

\item{include.extinct}{A \code{logical} indicating if extinct taxa should
be included in the final phylogeny.}
}
\value{
A \code{phylo} object
}
\description{
\code{simulateTree} uses a birth-death process to simulate a phylogenetic
tree, following the format of \code{ape} package's \code{phylo} object. The
function is basically a wrapper for the \code{diversitree}'s \code{tree.bd}
function.
}
\details{
see help page from \code{diversitree::tree.bd}
}
\examples{

S <- 1
E <- 0
set.seed(1)
phy <- simulateTree(pars = c(S, E), max.taxa = 6, max.t=Inf)
ape::plot.phylo(phy)
ape::axisPhylo()

# alternatively, we can stop the simulation using time:
set.seed(42)
phy2 <- simulateTree(pars = c(S, E), max.t=7)
ape::plot.phylo(phy2)
ape::axisPhylo()

}
\references{
Paradis, E. (2012). Analysis of Phylogenetics and Evolution with R (Vol. 2).
New York: Springer.

Popescu, A. A., Huber, K. T., & Paradis, E. (2012). ape 3.0: New tools for
distance-based phylogenetics and evolutionary analysis in R. Bioinformatics,
28(11), 1536-1537.

FitzJohn, R. G. (2010). Analysing diversification with diversitree.
R Packag. ver, 9-2.

FitzJohn, R. G. (2012). Diversitree: comparative phylogenetic analyses of
diversification in R. Methods in Ecology and Evolution, 3(6), 1084-1092.
}
\author{
Daniel Rabosky, Matheus Januario, Jennifer Auler
}
