% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LTRE_fns.R
\name{exactLTRE_random}
\alias{exactLTRE_random}
\title{Exact LTRE analysis: random design}
\usage{
exactLTRE_random(Aobj, maxint = "all")
}
\arguments{
\item{Aobj}{An object containing all the population projection matrices to be
included in the analysis. It should either be a list, or a matrix where each
row is the column-wise vectorization of a matrix. For random design, any
set of 2 or more matrices can be provided. The set of matrices passed in must
all have the same dimensions.}

\item{maxint}{The maximum interaction order to be evaluated. The default input
is "all" but this input can take any integer value. If maxint=3, then the
output will include contributions terms up to 3-way interactions.}
}
\value{
This returns a list object, with 3 items: (1) a vector of the matrix
indices where the parameters vary between/among the matrices in Aobj; (2) a
list of the indices varying for each of the contribution terms provided; (3)
a vector of the contribution terms.If the method is "fixed" then these are
contributions to the difference in lambda. If the method is "random" then
these are the contributions to the variance in lambda.

\code{indices.varying} is a vector with the indices of parameters that vary. The
numeric indices count down the columns of a given population projection
matrix. For example, in a 3x3 matrix, the (2,2) position would be identified
with a 5.

\code{varying.indices.list} is a list object, where each entry is a vector
containing the indices (matching the \code{indices.varying} part of the output)
that varied for the corresponding entry in the \code{epsilon} vector.

\code{epsilon} is a vector of contributions to the variance in lambda due to the
observed values of the various life history parameters. For example, the
contribution to the variance in lambda of adult survival is determined by
setting all parameters \emph{except} adult survival to their mean values, and
then calculating the variance in lambda in this manipulated set of matrices.
}
\description{
Life Table Response Experiments (LTREs) are a method of comparative demographic
analysis. The purpose is to quantify how the difference or variance in vital
rates (stage-specific survival, growth, and fertility) among populations
contributes to difference or variance in the population growth rate, "lambda."
The exact method of LTRE is based on the principles of functional ANOVA.
The equations and descriptions for the exact method will be published in a
forthcoming paper, which we will link to.
}
\details{
Lambda is the asymptotic population growth rate, defined as the
largest eigenvalue of the population projection matrix. A random design LTRE
decomposes the variance in lambda due to variance and covariance in the
entries at each position in the matrices. For a random design LTRE, at least
2 matrices must be provided.
}
\examples{
A1<- matrix(data=c(0,0.8,0, 0,0,0.7, 5,0,0.2), nrow=3, ncol=3)
A2<- matrix(data=c(0,0.9,0, 0,0,0.5, 4,0,0.3), nrow=3, ncol=3)
A3<- matrix(data=c(0,0.4,0, 0,0,0.6, 6,0,0.25), nrow=3, ncol=3)
cont_var<- exactLTRE_random(list(A1,A2,A3), maxint='all') # contributions to the variance of lambda
}
