% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_TestItemFunctions.R
\name{TetrachoricCorrelationMatrix}
\alias{TetrachoricCorrelationMatrix}
\alias{TetrachoricCorrelationMatrix.default}
\alias{TetrachoricCorrelationMatrix.binary}
\title{Tetrachoric Correlation Matrix}
\usage{
TetrachoricCorrelationMatrix(U, na = NULL, Z = NULL, w = NULL)

\method{TetrachoricCorrelationMatrix}{default}(U, na = NULL, Z = NULL, w = NULL)

\method{TetrachoricCorrelationMatrix}{binary}(U, na = NULL, Z = NULL, w = NULL)
}
\arguments{
\item{U}{Either an object of class "exametrika" or raw data. When raw data is given,
it is converted to the exametrika class with the \code{\link{dataFormat}} function.}

\item{na}{Values to be treated as missing values.}

\item{Z}{Missing indicator matrix of type matrix or data.frame. Values of 1 indicate
observed responses, while 0 indicates missing data.}

\item{w}{Item weight vector specifying the relative importance of each item.}
}
\value{
A matrix of tetrachoric correlations with exametrika class.
Each element (i,j) represents the tetrachoric correlation between items i and j.
The matrix is symmetric with ones on the diagonal.
}
\description{
Calculates the matrix of tetrachoric correlations between all pairs of items.
Tetrachoric Correlation is superior to the phi coefficient as a measure of the
relation of an item pair. This function is applicable only to binary response data.
}
\note{
This function is implemented using a binary data compatibility wrapper and
will raise an error if used with polytomous data.
}
\examples{
\donttest{
# example code
TetrachoricCorrelationMatrix(J15S500)
}
}
