% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ttest_data.R
\name{ttest_data}
\alias{ttest_data}
\alias{dt1}
\title{T-tests and Data Creation}
\usage{
ttest_data(
  size = (3:20)^2,
  mean = -5:5,
  sd = seq(0.1, 1, by = 0.1),
  reject = NA,
  alternative = c("two.sided", "less", "greater"),
  alpha = c(0.01, 0.05, 0.1),
  z = seq(-4.49, 4.49, by = 0.01),
  use.sigma = TRUE
)

dt1(
  size = (3:20)^2,
  mean = -5:5,
  sd = seq(0.1, 1, by = 0.1),
  reject = NA,
  alternative = c("two.sided", "less", "greater"),
  alpha = c(0.01, 0.05, 0.1),
  z = seq(-4.49, 4.49, by = 0.01),
  use.sigma = TRUE
)
}
\arguments{
\item{size}{numeric: vector of possible sample sizes (default \code{(3:20)^2,})}

\item{mean}{numeric: vector of possible means (default \code{-5:5})}

\item{sd}{numeric: vector of possible standard deviations (default \code{sd=seq(0.1, 1, by=0.1})}

\item{reject}{logical: should \code{x} generate a lead for the rejection of the null hypothesis (default \code{TRUE}), if equals \code{NA} then this will be ignored}

\item{alternative}{character: a character string specifying the alternative hypothesis, must be one of \code{two.sided} (default), \code{greater} or \code{less}}

\item{alpha}{numeric: vector of significance levels (default \code{c(0.01, 0.05, 0.1)})}

\item{z}{numeric: vector of possible \eqn{z} values (default \code{seq(-4.49, 4.49, by=0.01)})}

\item{use.sigma}{logical: should the standard deviation of the population (default) or the sample be used?}
}
\value{
A list with the components:
\itemize{
\item \code{mu0} hypothetical mean
\item \code{sigma} standard deviation in the population
\item \code{sd} vector of possible standard deviations in the sample
\item \code{xbar} mean in the sample
\item \code{n} sample size
\item \code{alpha} significance level
\item \code{alternative} specifying the alternative hypothesis (either \code{two.sided}, \code{greater} or \code{less})
\item \code{altsd} alternative values usable for \code{sd} (if \code{use.sigma==TRUE}) or \code{sigma} (if \code{use.sigma==FALSE})
}
}
\description{
Creates data for a t-test, for one mean, based on the test's properties.
}
\examples{
ttest_data()
}
