% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comments.R
\name{setComments}
\alias{setComments}
\title{Add comment to a specified cell}
\usage{
setComments(tableId, cellId, comment)
}
\arguments{
\item{tableId}{the id of the table for which the comment is to be added}

\item{cellId}{the id of the cell for which the comment is to be added}

\item{comment}{the comment that is to be added to the cell}
}
\description{
This function is used to add comment to the specified cell
}
\examples{
if(interactive()) {
 library(shiny)
 library(excelR)
 shinyApp(
  ui = fluidPage(excelOutput("table", height = 175),
       actionButton('comment', 'Set Comments to cell A1')),
     server = function(input, output, session) {
         output$table <- renderExcel(excelTable(data = head(iris)))
         observeEvent(input$comment,{
             setComments("table", "A1", "This is a comment")
         })
     }
     )
 }
}
