% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contourmap.R
\name{contourmap}
\alias{contourmap}
\title{Contour maps and contour map quality measures for latent Gaussian models}
\usage{
contourmap(
  mu,
  Q,
  vars,
  n.levels,
  ind,
  levels,
  type = c("standard", "pretty", "equalarea", "P0-optimal", "P1-optimal", "P2-optimal"),
  compute = list(F = TRUE, measures = NULL),
  use.marginals = TRUE,
  alpha,
  F.limit,
  n.iter = 10000,
  verbose = FALSE,
  max.threads = 0,
  seed = NULL
)
}
\arguments{
\item{mu}{Expectation vector.}

\item{Q}{Precision matrix.}

\item{vars}{Precomputed marginal variances (optional).}

\item{n.levels}{Number of levels in contour map.}

\item{ind}{Indices of the nodes that should be analyzed (optional).}

\item{levels}{Levels to use in contour map.}

\item{type}{Type of contour map. One of:
\describe{
\item{'standard' }{Equidistant levels between smallest and largest value
of the posterior mean (default).}
\item{'pretty' }{Equally spaced 'round' values which cover the range of
the values in the posterior mean.}
\item{'equalarea' }{Levels such that different spatial regions are
approximately equal in size.}
\item{'P0-optimal' }{Levels chosen to maximize the P0 measure.}
\item{'P1-optimal' }{Levels chosen to maximize the P1 measure.}
\item{'P2-optimal' }{Levels chosen to maximize the P2 measure.}
}}

\item{compute}{A list with quality indices to compute
\describe{
\item{'F': }{TRUE/FALSE indicating whether the contour map function
should be computed (default TRUE).}
\item{'measures': }{A list with the quality measures to compute
("P0", "P1", "P2") or corresponding bounds based only on the marginal
probabilities ("P0-bound", "P1-bound", "P2-bound").}
}}

\item{use.marginals}{Only marginal distributions are used when finding
P-optimal maps (default TRUE).}

\item{alpha}{Maximal error probability in contour map function (default=1).}

\item{F.limit}{The limit value for the computation of the F function. F is
set to NA for all nodes where \code{F < 1-F.limit}. Default is \code{F.limit = alpha}.}

\item{n.iter}{Number or iterations in the MC sampler that is used for
calculating the quantities in \code{compute}. The default value is 10000.}

\item{verbose}{Set to TRUE for verbose mode (optional).}

\item{max.threads}{Decides the number of threads the program can use. Set to
0 for using the maximum number of threads allowed by the system (default).}

\item{seed}{Random seed (optional).}
}
\value{
\code{contourmap} returns an object of class "excurobj" with the following elements
\item{u }{Contour levels used in the contour map.}
\item{n.levels }{The number of contours used.}
\item{u.e }{The values associated with the level sets G_k.}
\item{G }{A vector which shows which of the level sets G_k each node belongs to.}
\item{map }{Representation of the contour map with \code{map[i]=u.e[k]} if i is in \code{G_k}.}
\item{F }{The contour map function (if computed).}
\item{M }{Contour avoiding sets (if \code{F} is computed). \eqn{M=-1} for all non-significant nodes and  \eqn{M=k} for nodes that belong to \eqn{M_k}.}
\item{P0/P1/P2 }{Calculated quality measures (if computed).}
\item{P0bound/P1bound/P2bound }{Calculated upper bounds quality measures (if computed).}
\item{meta }{A list containing various information about the calculation.}
}
\description{
\code{contourmap} is used for calculating contour maps and quality measures for
contour maps for Gaussian models.
}
\details{
The Gaussian model is specified using the mean \code{mu} and the precision matrix
\code{Q}. The contour map is then computed for the mean, using either the contour
levels specified in \code{levels}, or \code{n.levels} contours that are placed according
to the argument \code{type}.

A number of quality measures can be computed based based on the specified contour map
and the Gaussian distribution. What should be computed is specified using the
\code{compute} argument. For details on these quanties, see the reference below.
}
\examples{
n <- 10
Q <- Matrix(toeplitz(c(1, -0.5, rep(0, n - 2))))
mu <- seq(-5, 5, length = n)
lp <- contourmap(mu, Q,
  n.levels = 2,
  compute = list(F = FALSE, measures = c("P1", "P2")),
  max.threads = 1
)
# Plot the contourmap
plot(lp$map)
# Display the quality measures
cat(c(lp$P1, lp$P2))
}
\references{
Bolin, D. and Lindgren, F. (2017) \emph{Quantifying the uncertainty of contour maps}, Journal of Computational and Graphical Statistics, vol 26, no 3, pp 513-524.

Bolin, D. and Lindgren, F. (2018), \emph{Calculating Probabilistic Excursion Sets and Related Quantities Using excursions}, Journal of Statistical Software, vol 86, no 1, pp 1-20.
}
\seealso{
\code{\link[=contourmap.inla]{contourmap.inla()}}, \code{\link[=contourmap.mc]{contourmap.mc()}}, \code{\link[=contourmap.colors]{contourmap.colors()}}
}
\author{
David Bolin \email{davidbolin@gmail.com}
}
