% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reporting.R
\name{distribution}
\alias{distribution}
\title{Distribution by batch}
\usage{
distribution(report, column)
}
\arguments{
\item{report}{A data.frame which must contain a batch column. Which can be
obtained with \code{\link[=inspect]{inspect()}}.}

\item{column}{The name of the column one wants to inspect.}
}
\value{
\code{TRUE} if the values are maximal distributed, otherwise \code{FALSE}.
}
\description{
Checks if all the values are maximally distributed in the several batches.
Aimed for categorical variables.
}
\examples{
data(survey, package = "MASS")
columns <- c("Sex", "Age", "Smoke")
nas <- c(137, 70) # Omit rows with NA to avoid warnings in design
index <- design(pheno = survey[-nas, columns], size_subset = 70,
                iterations = 10)
batches <- inspect(index, survey[-nas, columns])
distribution(batches, "Sex")
distribution(batches, "Smoke")
}
