% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eSHAP_plot_multiclass.R
\name{eSHAP_plot_multiclass}
\alias{eSHAP_plot_multiclass}
\title{Enhanced SHAP Analysis for Multi-Class Classification Models}
\usage{
eSHAP_plot_multiclass(
  task,
  trained_model,
  splits,
  sample.size = 30,
  seed = 246,
  subset = 1
)
}
\arguments{
\item{task}{mlr3 task object for multi-class classification}

\item{trained_model}{mlr3 trained learner object}

\item{splits}{mlr3 object defining data splits for train and test sets}

\item{sample.size}{numeric, default to 30. The larger the value, the slower but more accurate the estimate of SHAP values}

\item{seed}{numeric, an integer for reproducibility. Default to 246}

\item{subset}{numeric, what percentage of the instances to use from 0 to 1 where 1 means all}
}
\value{
A list containing:
\item{combined_plots}{SHAP plot depicting the SHAP values for each class}
\item{shap_data}{A matrix of SHAP values for each class.}
\item{combined_all_classes}{overall SHAP plot depicting the SHAP values for all classes on a single plot}
}
\description{
The SHAP plot for multi-class classification models is a visualization tool that uses the Shapley value to compute feature contributions for single predictions across multiple classes.
}
\examples{
\donttest{
library("explainer")
seed <- 246
set.seed(seed)
# Load necessary packages and data...
}

}
\seealso{
Other classification: 
\code{\link{eSHAP_plot}()}

Other SHAP: 
\code{\link{eSHAP_plot}()}
}
\concept{SHAP}
\concept{classification}
\keyword{internal}
