% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/res.R
\name{res_skewnorm}
\alias{res_skewnorm}
\title{Skew Normal Residuals}
\usage{
res_skewnorm(x, mean = 0, sd = 1, shape = 0, type = "dev", simulate = FALSE)
}
\arguments{
\item{x}{A numeric vector of values.}

\item{mean}{A numeric vector of the means.}

\item{sd}{A non-negative numeric vector of the standard deviations.}

\item{shape}{A numeric vector of shape.}

\item{type}{A string of the residual type. 'raw' for raw residuals 'dev' for
deviance residuals and 'data' for the data.}

\item{simulate}{A flag specifying whether to simulate residuals.}
}
\value{
An numeric vector of the corresponding residuals.
}
\description{
Skew Normal Residuals
}
\examples{
\dontshow{if (rlang::is_installed("sn")) withAutoprint(\{ # examplesIf}
res_skewnorm(c(-2:2))
\dontshow{\}) # examplesIf}
}
\seealso{
Other res_dist: 
\code{\link{res_bern}()},
\code{\link{res_beta_binom}()},
\code{\link{res_binom}()},
\code{\link{res_gamma}()},
\code{\link{res_gamma_pois}()},
\code{\link{res_gamma_pois_zi}()},
\code{\link{res_lnorm}()},
\code{\link{res_neg_binom}()},
\code{\link{res_norm}()},
\code{\link{res_pois}()},
\code{\link{res_pois_zi}()},
\code{\link{res_student}()}
}
\concept{res_dist}
