% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ANALYSE__functions.R
\name{analyse.sac.amplitude}
\alias{analyse.sac.amplitude}
\title{Analyse saccade amplitude}
\usage{
analyse.sac.amplitude(
  fixreport_df,
  aggregation_column_list = c(),
  spss = FALSE,
  prefixLabel = ""
)
}
\arguments{
\item{fixreport_df}{Fixation report}

\item{aggregation_column_list}{List of columns to group by}

\item{spss}{Should the function save output for SPSS?}

\item{prefixLabel}{Prefix label}
}
\value{
If spss is set to FALSE (which is the default), you'll get an object containing data.tables 
of by-trial means for sacade amplitudes, by-trial means for particpants, and overall descriptive
statistics for use when creating graphs based on your data. If spss is set to TRUE, then you'll be 
provided with a 'wide' version of the data for analysis in packages such as SPSS. The function will
also save a copy of the for-spss file for you as well.
}
\description{
Analyse saccade amplitude
}
\examples{
# BREAK UP BY TARGET-PRESENT AND TARGET-ABSENT TRIALS - THE COLUMN TRIALTYPE_TEXT
data(fixationreport)
amplitudes <- analyse.sac.amplitude(fixationreport, 
    aggregation_column_list = list('TRIALTYPE_TEXT'))
}
