% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bayes-ECM.R
\name{predict.BayesECM}
\alias{predict.BayesECM}
\title{New Event Categorization With Bayesian Inference}
\usage{
\method{predict}{BayesECM}(object, Ytilde, thinning = 1, mixture_weights = "training", ...)
}
\arguments{
\item{object}{an object of \code{class} \code{"BayesECM"} obtained as the trained model output using the \code{\link[=BayesECM]{BayesECM()}} function.}

\item{Ytilde}{\code{data.frame} of unlabeled observations to be categorized.  Must contain the same discriminant names as the training data used in the provided "BayesECM" object.  Each row is an individual observation.  Missing data is specified with \code{NA}}

\item{thinning}{integer, scalar.  Values greater than one can be provided to reduce computation time.  See details.}

\item{mixture_weights}{character string describing the weights of the distributions in the mixture to be used for prediction.  The default,\code{"training"} will utilize weights according to likelihood and prior specifications, while supplying the string \code{"equal"} will assume the marginal predictive distribution of each category is independent of the data and utilize equal weights.}

\item{...}{not used}
}
\value{
Returns a \code{list}.  The list element \code{epz} is a matrix with \code{nrow(Ytilde)} rows, corresponding to each event used for prediction, and \code{K} named columns.  Each column of \code{epz} is the expected category probability of the row stipulated event.  The remainder of the list elements hold data including \code{Ytilde}, information about additonal variables passed to \code{predict.BayesECM}, and data related to the previous \code{\link[=BayesECM]{BayesECM()}} fit.
}
\description{
New Event Categorization With Bayesian Inference
}
\details{
The data in \code{Ytilde} should be the p-values \eqn{\in (0,1]}.  The transformation applied to the data used to generate \code{object} is automatically applied to \code{Ytilde} within the \code{predict.BayesECM()} function.

For a given event with an unknown category, a Bayesian ECM model seeks to predict the expected value of the latent variable \eqn{\tilde{\mathbf{z}}_K}, where \eqn{\tilde{\mathbf{z}}_K} is a vector of the length \eqn{K}, and \eqn{K} is the number of event categories.  A single observation of \eqn{\tilde{\mathbf{z}}_K} is a draw from a \href{https://en.wikipedia.org/wiki/Categorical_distribution}{Categorical Distribution}.

The expected probabilities stipulated within the categorical distribution of \eqn{\tilde{\mathbf{z}}_K} are conditioned on any imputed missing data, prior hyperparameters, and individually each row of \code{Ytilde}. The output from \code{\link[=predict.BayesECM]{predict.BayesECM()}} are draws from the distribution of \eqn{\mathbf{E}[\tilde{\mathbf{z}}_K|\tilde{\mathbf{y}}_{\tilde{p}}, \mathbf{Y}^{+}, \mathbf{\eta}, \mathbf{\Psi}, \mathbf{\nu}, \mathbf{\alpha}] = p(\tilde{\mathbf{z}}_K|\tilde{\mathbf{y}}_{\tilde{p}}, \mathbf{Y}^{+}, \mathbf{\eta}, \mathbf{\Psi}, \mathbf{\nu}, \mathbf{\alpha})}, where \eqn{\mathbf{Y}^{+}} represents the observed values within the training data.

The argument \code{mixture_weights} controls the value of \eqn{p(\tilde{\mathbf{z}}_K|\mathbf{Y}_{N \times p}, \mathbf{\alpha})}, the probability of each \eqn{\tilde{z}_k = 1}, before \eqn{\tilde{\mathbf{y}}_{\tilde{p}}} is observed.  The standard result is obtained from the prior hyperparameter values in \eqn{\mathbf{\alpha}} and the number of unique events in each \eqn{\mathbf{Y}_{N_k \times p}}.  Setting \code{mixture_weights = "training"} will utilize this standard result in prediction.  If the frequency of the number events used for each category in training is thought to be problematic, providing the argument \code{mixture_weights = "equal"} sets \eqn{p(\tilde{z}_1 = 1|\mathbf{Y}_{N \times p}) =  \dots = p(\tilde{z}_K = 1|\mathbf{Y}_{N \times p}) = 1/K}.  If the user wants to use a set of \eqn{p(\tilde{z}_k = 1|\mathbf{Y}_{N \times p})} which are not equal but also not informed by the data, we suggest setting the elements of the hyperparameter vector \eqn{\mathbf{\alpha}} equal to values with a large magnitude and in the desired ratios for each category.  However, this can cause undesirable results in prediction if the magnitude of some elements of \eqn{\mathbf{\alpha}} are orders larger than others.

To save computation time, the user can specify an integer value for \code{thinning} greater than one.  Every \code{thinning}th Markov-chain Monte-Carlo sample is used for prediction.  This lets the user take a large number of samples during the training step, allowing for better mixing.  See details in a package vignette by running \code{vignette("syn-data-code", package = "ezECM")}
}
\examples{

csv_use <- "good_training.csv"
file_path <- system.file("extdata", csv_use, package = "ezECM")
training_data <- import_pvals(file = file_path, header = TRUE, sep = ",", training = TRUE)

trained_model <- BayesECM(Y = training_data, BT = c(10,1000))

csv_use <- "good_newdata.csv"
file_path <- system.file("extdata", csv_use, package = "ezECM")
new_data <- import_pvals(file = file_path, header = TRUE, sep = ",", training = TRUE)

bayes_pred <- predict(trained_model,  Ytilde = new_data)


}
