% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import.R
\name{import}
\alias{import}
\alias{import,}
\alias{getImport}
\title{Import and transform a dataset into long format}
\usage{
import()
}
\description{
This graphical users interface (GUI) can be used for inserting .csv, .txt and .sav-files in R by means of a pop-up window. It also allows to transform a dataset from wide into the requiered long format for the fSRM-function. The output format for the SRM components can be confirmed or modified.
}
\details{
This GUI allows the user three different things: 
(i) Import a datafile in R. 
The upper section of the main window allows to insert .csv, .txt and .sav-files in R. It is required that the first row of this datafile contains the variable names.
(ii) Transform a dataset that is in wide format into the desired long format, in order to use the \code{fSRM}-function.
A new pop-up window appears after clicking on 'transform my data' in the middle section. This new window allows to transform a dataset from wide format (i.e. each column represents one measured relationship, each row one family) to the necessary long format. Specify - if present - first the variable names which identifies the different families and groups, respectively.
Next, specify the columns in the original dataset which contain the dyadic measurements. Enumerated columns need to be separated with a comma, consecutive columns need to be defined by means of colon (e.g. 1 : 9 defines the first until the second column in the original dataset).
Finally, define the position of the characters of the rater, the person being rated and the indicator (if present) in the previously selected dyadic measurements.
(iii) Define the desired output-format for the different SRM-components.
At the bottom section of the main window the user can agree with the default labels of the SRM components by clicking on 'Confirm output format' or specify alternative labels.

Importing a data set is a two-step process. First, you have to call the \code{import} function. When you click on OK, the transformed data set is saved in a hidden variable. To access the variable, you have to call \code{getImport}.
}
\examples{
\dontrun{
import()
# --> now click throught the menu
dat <- getImport()	
}
}
