#' Minnesota Radon Data
#'
#' Data from a national US EPA survey of household radon values. County index contained in group column.
#'
#' @docType data
#'
#' @usage data(radon)
#'
#' @format A matrix.
#'
#' @keywords datasets
#'
#' @references US Environmental Protection Agency (1992) National residential radon survey: summary report.
#' Washington, DC; DOI EPA402-R-92-011.
#'
#' @source \href{http://www.stat.columbia.edu/~gelman/arm/examples/radon/}{ARM Data}
#' 
"radon"

#' Minnesota County Adjacency Matrix
#'
#' Adjacency matrix for MN counties based on group index that matches radon data.
#'
#' @docType data
#'
#' @usage data(W)
#'
#' @format A matrix.
#'
#' @keywords datasets
#' 
"W"