% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fac2x2analyze.R
\name{fac2x2analyze}
\alias{fac2x2analyze}
\title{Significance testing for the Proportional Allocation 2, Equal Allocation 3,
Equal Allocation 2 procedures}
\usage{
fac2x2analyze(time, event, indA, indB, covmat, alpha, dig = 2, niter = 5)
}
\arguments{
\item{time}{follow-up times}

\item{event}{event indicators (0/1)}

\item{indA}{treatment A indicators (0/1)}

\item{indB}{treatment B indicators (0/1)}

\item{covmat}{covariate matrix, must be non-NULL.  Factor variables MUST use 0/1 dummy variables}

\item{alpha}{two-sided familywise significance level}

\item{dig}{number of decimal places to which we \code{\link{roundDown}} the critical value}

\item{niter}{number of interations passed to \code{crit2x2} function call}
}
\value{
\item{loghrAoverall }{overall A log hazard ratio}

\item{seAoverall }{standard error of the overall A log hazard ratio}

\item{ZstatAoverall }{Z-statistic for the overall A log hazard ratio}

\item{pvalAoverall }{two-sided p-value for the overall hazard ratio}

\item{hrAoverall }{overall A hazard ratio}

\item{ciAoverall }{95\% confidence interval for the overall A hazard ratio}

\item{loghrAsimple }{simple A log hazard ratio}

\item{seAsimple }{standard error of the simple A log hazard ratio}

\item{ZstatAsimple }{Z-statistic for the simple A log hazard ratio}

\item{pvalAsimple }{two-sided p-value for the simple A hazard ratio}

\item{hrAsimple }{simple A hazard ratio}

\item{ciAsimple }{95\% confidence interval for the simple A hazard ratio}

\item{loghrABsimple }{simple AB log hazard ratio}

\item{seABsimple}{standard error of the simple AB log hazard ratio}

\item{ZstatABsimple }{Z-statistic for the simple AB log hazard ratio}

\item{pvalABsimple }{two-sided p-value for the simple AB hazard ratio}

\item{hrABsimple }{simple AB hazard ratio}

\item{ciABsimple }{95\% confidence interval for the simple AB hazard ratio}

\item{critEA3_A }{Equal Allocation 3's critical value for the overall A simple A, and simple AB hypotheses}

\item{sigEA3_A }{Equal Allocation 3's p-value rejection criterion for the overall A, simple A, and simple AB hypotheses}

\item{resultEA3_A }{Equal Allocation 3's accept/reject decisions for the overall A, simple A, and simple AB hypotheses}

\item{critPA2overallA }{Proportional Allocation 2's critical value for the overall A statistic}

\item{sigPA2overallA }{Proportional Allocation 2's p-value rejection criterion for the overall A hypothesis}

\item{critPA2simpleAB}{Proportional Allocation 2's critical value for the simple AB hypothesis}

\item{sigPA2simpleAB }{Proportional Allocation 2 procedure's p-value rejection criterion for the simple AB hypothesis}

\item{resultPA2_A }{Proportional Allocation 2 procedure's accept/reject decisions for the overall A and simple A hypotheses}

\item{critEA2_A }{Equal Allocation 2 procedure's critical value for the simple A and simple AB hypotheses}

\item{sigEA2_A }{Equal Allocation 2 procedure's p-value rejection criterion for the simple A and simple AB hypotheses}

\item{resultEA2_A }{Equal Allocation 2 procedure's accept/reject decisions for the simple A and simple AB hypotheses }

\item{corAa }{correlation between the overall A and simple A logrank statistics}

\item{corAab }{correlation between the overall A and simple AB logrank statistics}

\item{coraab }{correlation between the simple A and simple AB logrank statistics}
}
\description{
Performs significance testing for the Proportional Allocation 2, Equal Allocation 3,
Equal Allocation 2 procedures.
Also reports the hazard ratios, 95\% confidence intervals, p-values,
nominal significance levels, and correlations for the overall and simple
test statistics.
}
\details{
For each of the three multiple testing procedures, the critical values for
the overall A (respectively, simple A) logrank statistics may be slightly different
from the overall B (respectively, simple B) logrank statistics.  This is
due to their slightly different correlations with each other (i.e., correlation
between overall A and simple A, respectively, overall B and simple B,
statistics) as well as with  the simple AB statistic.
}
\examples{
 # First load the simulated data variables. The "simdataSub" file is
 # a 100-by-9 matrix which is loaded with the factorial2x2 package.
 time <- simdataSub[, "time"]
 event <- simdataSub[, "event"]
 indA <- simdataSub[, "indA"]
 indB <- simdataSub[, "indB"]
 covmat <- simdataSub[, 6:10]
 fac2x2analyze(time, event, indA, indB, covmat, alpha = 0.05, niter = 5)
#  $loghrA
# [1] 0.05613844

# $seA
# [1] 0.4531521

# $ZstatA
# [1] 0.1238843

# $pvalA
# [1] 0.9014069

# $hrA
# [1] 1.057744

# $ciA
# [1] 0.4351608 2.5710556

# $loghra
# [1] 0.1987329

# $sea
# [1] 0.6805458

# $Zstata
# [1] 0.2920198

# $pvala
# [1] 0.7702714

# $hra
# [1] 1.219856

# $cia
# [1] 0.3213781 4.6302116

# $loghrab
# [1] 0.2864932

# $seab
# [1] 0.6762458

# $Zstatab
# [1] 0.4236525

# $pvalab
# [1] 0.6718193

# $hrab
# [1] 1.331749

# $ciab
# [1] 0.3538265 5.0125010

# $critPA2A
# [1] -2.129

# $sigPA2A
# [1] 0.03325426

# $critPA2ab
# [1] -2.299

# $sigPA2ab
# [1] 0.02150494

# $result23
# [1] "accept overall A" "accept simple AB"

# $critEA3
# [1] -2.338

# $sigEA3
# [1] 0.01938725

# $result13
# [1] "accept overall A" "accept simple A"  "accept simple AB"

# $critEA2
# [1] -2.216

# $sigEA2
# [1] 0.0266915

# $result12
# [1] "accept simple A"  "accept simple AB"

# $corAa
# [1] 0.6123399

# $corAab
# [1] 0.5675396

# $coraab
# [1] 0.4642737
}
\references{
Leifer, E.S., Troendle, J.F., Kolecki, A., Follmann, D.
Joint testing of overall and simple effect for the two-by-two factorial design. (2020). Submitted.

Lin, D-Y., Gong, J., Gallo, P., et al. Simultaneous inference on treatment effects
in survival studies with factorial designs. Biometrics. 2016; 72: 1078-1085.

Slud, E.V. Analysis of factorial survival experiments. Biometrics. 1994; 50: 25-38.
}
\author{
Eric Leifer, James Troendle
}
