% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cproxyme.R
\name{cproxyme}
\alias{cproxyme}
\title{cproxyme}
\usage{
cproxyme(dat, anchor = 1, weights = NULL)
}
\arguments{
\item{dat}{A proxy variable data frame list.}

\item{anchor}{This is a column index of an anchoring proxy variable. Default is 1. That is, the code will use the first column in dat data frame as an achoring variable.}

\item{weights}{An optional weight vector}
}
\value{
Returns a list of 3 components : \describe{
\item{alpha0}{This is a vector of intercepts in a linear factor model. The k-th entry is the intercept of k-th proxy variable factor model.}

\item{alpha1}{This is a vector of factor loadings. The k-th entry is the factor loading of k-th proxy variable. The factor loading of anchoring variable is normalized to 1.}

\item{varnu}{This is a vector of variances of measurement errors in proxy variables. The k-th entry is the variance of k-th proxy measurement error. The measurement error is assumed to follow a Normal distribution with mean 0.}

\item{mtheta}{This is a mean of the latent variable. It is equal to the mean of the anchoring proxy variable.}

\item{vartheta}{This is a variance of the latent variable.}}
}
\description{
This function estimates a linear factor model using continuous variables.
The linear factor model to estimate has the following form.
proxy = intercept + factorloading * (latent variable) + measurement error
The measurement error is assumed to follow a Normal distribution with a mean zero and a variance, which needs to be estimated.
}
\examples{
dat1 <- data.frame(proxy1=c(1,2,3),proxy2=c(0.1,0.3,0.6),proxy3=c(2,3,5))
cproxyme(dat=dat1,anchor=1)
## you can specify weights
cproxyme(dat=dat1,anchor=1,weights=c(0.1,0.5,0.4))

}
\references{
\describe{
\item{Cunha, F., Heckman, J. J., & Schennach, S. M. (2010)}{Estimating the technology of cognitive and noncognitive skill formation. Econometrica, 78(3), 883-931. \doi{10.3982/ECTA6551}}
\item{Hwang, Yujung (2021)}{Bounding Omitted Variable Bias Using Auxiliary Data. Working Paper.}}
}
\author{
Yujung Hwang, \email{yujungghwang@gmail.com}
}
