% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fairadapt.R, R/generics.R
\name{fairadapt}
\alias{fairadapt}
\alias{print.fairadapt}
\title{Fair data adaptation (fairadapt)}
\usage{
fairadapt(
  formula,
  prot.attr,
  adj.mat,
  train.data,
  test.data = NULL,
  cfd.mat = NULL,
  top.ord = NULL,
  res.vars = NULL,
  quant.method = rangerQuants,
  visualize.graph = FALSE,
  eval.qfit = NULL,
  ...
)

\method{print}{fairadapt}(x, ...)
}
\arguments{
\item{formula}{Object of class \code{formula} describing the response and
the covariates.}

\item{prot.attr}{A value of class \code{character} describing the binary
protected attribute. Must be one of the entries of \code{colnames(adj.mat)}.}

\item{adj.mat}{Matrix of class \code{matrix} encoding the relationships in
the causal graph. \code{M[i,j] == 1L} implies the existence of an edge from
node i to node j. Must include all the variables appearing in the formula
object. When the \code{adj.mat} argument is set to \code{NULL}, then the
\code{top.ord} argument has to be supplied.}

\item{train.data, test.data}{Training data & testing data, both of class
\code{data.frame}. Test data is by default \code{NULL}.}

\item{cfd.mat}{Symmetric matrix of class \code{matrix} encoding the
bidirected edges in the causal graph. \verb{M[i,j] == M[j, i] == 1L}
implies the existence of a bidirected edge between nodes i and j. Must
include all the variables appearing in the formula object.}

\item{top.ord}{A vector of class \code{character} describing the
topological ordering of the causal graph. Default value is \code{NULL},
but this argument must be supplied if \code{adj.mat} is not specified.
Also must include all the variables appearing in the formula object.}

\item{res.vars}{A vector of class \code{character} listing all the resolving
variables, which should not be changed by the adaption procedure. Default
value is \code{NULL}, corresponding to no resolving variables. Resolving
variables should be a subset of the descendants of the protected attribute.}

\item{quant.method}{A function choosing the method used for quantile
regression. Default value is \code{rangerQuants} (using random forest
quantile regression). Other implemented options are \code{linearQuants} and
\code{mcqrnnQuants}. A custom function can be supplied by the user here,
and the associated method for the S3 generic \code{computeQuants} needs to be
added.}

\item{visualize.graph}{A \code{logical} indicating whether the causal graph
should be plotted upon calling the \code{fairadapt()} function. Default
value is \code{FALSE}.}

\item{eval.qfit}{Argument indicating whether the quality of the quantile
regression fit should be computed using cross-validation. Default value is
\code{NULL}, but whenever a positive integer value is specified, then it is
interpreted as the number of folds used in the cross-validation procedure.}

\item{...}{Additional arguments forwarded to the function passed as
\code{quant.method}.}

\item{x}{Object of class \code{"fairadapt"}.}
}
\value{
An object of class \code{fairadapt}, containing the original and
adapted training and testing data, together with the causal graph and some
additional meta-information.
}
\description{
Implementation of fair data adaptation with quantile preservation
(Plecko & Meinshausen, 2020). Uses only plain \code{R}.
}
\details{
The procedure takes the training and testing data as an input, together with
the causal graph given by an adjacency matrix and the list of resolving
variables, which should be kept fixed during the adaptation procedure. The
procedure then calculates a fair representation of the data, after which
any classification method can be used. There are, however, several valid
training options yielding fair predictions, and the best of them can be
chosen with cross-validation. For more details we refer the user to the
original paper. Most of the running time is due to the quantile regression
step using the ranger package.
}
\examples{
n_samp <- 200
uni_dim <- c(       "gender", "edu", "test", "score")
uni_adj <- matrix(c(       0,     1,      1,       0,
                           0,     0,      1,       1,
                           0,     0,      0,       1,
                           0,     0,      0,       0),
                  ncol = length(uni_dim),
                  dimnames = rep(list(uni_dim), 2),
                  byrow = TRUE)

uni_ada <- fairadapt(score ~ .,
  train.data = head(uni_admission, n = n_samp),
  test.data = tail(uni_admission, n = n_samp),
  adj.mat = uni_adj,
  prot.attr = "gender"
)

uni_ada

}
\references{
Plecko, D. & Meinshausen, N. (2020).
Fair Data Adaptation with Quantile Preservation.
Journal of Machine Learning Research, 21(242), 1-44.

Plecko, D. & Bennett, N. & Meinshausen, N. (2024).
fairadapt: Causal reasoning for fair data pre-processing.
Journal of Statistical Software, 110(4).
\doi{10.18637/jss.v110.i04}.
}
