% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fake_client.R
\name{fake_ticket_client}
\alias{fake_ticket_client}
\title{Base ticket client}
\usage{
fake_ticket_client(
  vol,
  x,
  n = 200,
  split = FALSE,
  seed = 2811,
  local = c("en_US", "fr_FR")
)
}
\arguments{
\item{vol}{le nombre de tickets a retourner}

\item{x}{Optionnal. fake client data base}

\item{n}{Number of clients in the client database if x not provided}

\item{split}{la base doit elle être separee en deux ?}

\item{seed}{fixe la graine aleatoire}

\item{local}{the local of the base. Currently supported : "fr_FR" and "en_US".}
}
\value{
A dataframe of fake tickets.
}
\description{
Une fausse base client de ticket Telecom
}
\details{
\itemize{
  \item Same client can have multiple tickets
  \item Some clients are more sampled than others
  \item Some types are more sampled than others
  \item Some etat are more sampled than others
}
}
\examples{
x <- fake_ticket_client(1000, split = TRUE)
plot(x$clients$entry_date, x$clients$fidelity_points)
barplot(table(x$tickets$type))
barplot(table(x$tickets$state))

}
