% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fasttext.R
\name{ft_train}
\alias{ft_train}
\title{Train a Model}
\usage{
ft_train(
  file,
  method = c("supervised", "cbow", "skipgram"),
  control = ft_control(),
  ...
)
}
\arguments{
\item{file}{a character string giving the location of the input file.}

\item{method}{a character string giving the method, possible values are
\code{'supervised'}, \code{'cbow'} and \code{'skipgram'}.}

\item{control}{a list giving the control variables, for more information
see \code{\link{ft_control}}.}

\item{...}{additional control arguments inserted into the control list.}
}
\description{
Train a new word representation model or supervised
             classification model.
}
\examples{
\dontrun{
cntrl <- ft_control(nthreads = 1L)
model <- ft_train("my_data.txt", method="supervised", control = cntrl)
}
}
