% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_did.R
\name{sim_did}
\alias{sim_did}
\title{Simulate a Difference-in-Differences (DiD) dataset}
\usage{
sim_did(
  sample_size,
  time_period,
  untreated_prop = 0.3,
  epsilon_size = 0.001,
  cov = "no",
  hetero = "all",
  second_outcome = FALSE,
  second_cov = FALSE,
  vary_cov = FALSE,
  na = "none",
  balanced = TRUE,
  seed = NA,
  stratify = FALSE,
  treatment_assign = "latent",
  second_cohort = FALSE,
  confound_ratio = 1,
  second_het = "all"
)
}
\arguments{
\item{sample_size}{The number of units in the dataset.}

\item{time_period}{The number of time periods in the dataset.}

\item{untreated_prop}{The proportion of untreated units.}

\item{epsilon_size}{The standard deviation for the error term in potential outcomes.}

\item{cov}{The type of covariate to include ("no", "int", or "cont").}

\item{hetero}{The type of heterogeneity in treatment effects ("all" or "dynamic").}

\item{second_outcome}{Whether to include a second outcome variable.}

\item{second_cov}{Whether to include a second covariate.}

\item{vary_cov}{include time-varying covariates}

\item{na}{Whether to generate missing data ("none", "y", "x", or "both").}

\item{balanced}{Whether to balance the dataset by random sampling.}

\item{seed}{Seed for random number generation.}

\item{stratify}{Whether to stratify the dataset based on a binary covariate.}

\item{treatment_assign}{The method for treatment assignment ("latent" or "uniform").}

\item{second_cohort}{include confounding events}

\item{confound_ratio}{extent of event confoundedness}

\item{second_het}{heterogeneity of the second event}
}
\value{
A list containing the simulated dataset (dt) and the treatment effect values (att).
}
\description{
Simulates a dataset for a Difference-in-Differences analysis with various customizable options.
}
\examples{
# Simulate a DiD dataset with default settings
data <- sim_did(sample_size = 100, time_period = 5)

}
