% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kqr.R
\name{kqr}
\alias{kqr}
\title{Solve the kernel quantile regression. The solution path is computed
at a grid of values of tuning parameter \code{lambda}.}
\usage{
kqr(
  x,
  y,
  lambda,
  tau,
  delta = 0.125,
  eps = 1e-05,
  maxit = 1e+06,
  gam = 1e-07,
  sigma = NULL,
  is_exact = FALSE
)
}
\arguments{
\item{x}{A numerical input matrix. The dimension is \eqn{n} rows and \eqn{p} columns.}

\item{y}{Response variable. The length is \eqn{n}.}

\item{lambda}{A user-supplied \code{lambda} sequence.}

\item{tau}{A user-supplied \code{tau} value for a quantile level.}

\item{delta}{The smoothing index for \code{method='huber'}. Default is 0.125.}

\item{eps}{Stopping criterion.}

\item{maxit}{Maximum number of iterates.}

\item{gam}{A small number for numerical stability.}

\item{sigma}{Kernel bandwidth.}

\item{is_exact}{Exact or approximated solutions. Default is \code{FALSE}.}
}
\value{
An object with S3 class \code{kqr}
\item{alpha}{An \eqn{n+1} by \eqn{L} matrix of coefficients, where \eqn{n} is the number of observations
and \eqn{L} is the number of tuning parameters. The first row of \code{alpha} contains the intercepts.}
\item{lambda}{The \code{lambda} sequence that was actually used.}
\item{delta}{The smoothing index.}
\item{npass}{The total number of iterates used to train the classifier.}
\item{jerr}{Warnings and errors; 0 if none.}
\item{info}{A list includes some settings used to fit this object: \code{eps}, \code{maxit}}.
}
\description{
Solve the kernel quantile regression. The solution path is computed
at a grid of values of tuning parameter \code{lambda}.
}
\details{
The function implements an accelerated proximal gradient descent to solve
kernel quantile regression.
}
\examples{
library(MASS)
data(GAGurine)
x <- as.matrix(GAGurine$Age)
y <- GAGurine$GAG
lambda <- 10^(seq(1, -4, length.out=30))
fit <- kqr(x, y, lambda=lambda, tau=0.1, is_exact=TRUE)
}
\keyword{quantile}
\keyword{regression}
