% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nckqr.R
\name{nckqr}
\alias{nckqr}
\title{Solve the non-crossing kernel quantile regression}
\usage{
nckqr(
  x,
  y,
  lambda1,
  lambda2,
  tau,
  delta = 0.125,
  eps = 1e-08,
  maxit = 5e+06,
  gam = 1e-07,
  sigma = NULL,
  kernel = "rbfdot",
  is_exact = FALSE
)
}
\arguments{
\item{x}{A numerical input matrix. The dimension is \eqn{n+1} by \eqn{ntau} by \eqn{L1} by \eqn{L2}.}

\item{y}{Response variable. The length is \eqn{n}.}

\item{lambda1}{A user-supplied \code{lambda1} sequence. The length is \eqn{L1}.}

\item{lambda2}{A user-supplied \code{lambda2} sequence. The length is \eqn{L2}.}

\item{tau}{A user-supplied \code{tau} sequence for quantile levels. The length is \eqn{ntau}.}

\item{delta}{The smoothing index for \code{method='huber'}. Default is 0.125.}

\item{eps}{Stopping criterion.}

\item{maxit}{Maximum number of iterates.}

\item{gam}{A small number for numerical stability.}

\item{sigma}{Kernel bandwidth.}

\item{kernel}{Name of kernel function. Default is "Gaussian".}

\item{is_exact}{Exact or approximated solutions.}
}
\value{
An object with S3 class \code{nckqr}
\item{alpha}{An \eqn{n+1} by \eqn{L} matrix of coefficients, where \eqn{n} represents the number of observations,
\eqn{ntau} represents the number of quantile levels, and \eqn{L} denotes the number of tuning parameters.}
\item{tau}{The \code{tau} sequence that was actually used.}
\item{lambda1}{The \code{lambda1} sequence that was actually used.}
\item{lambda2}{The \code{lambda2} sequence that was actually used.}
\item{delta}{The smoothing index.}
\item{npass}{The total number of iterates used to train the classifier.}
\item{jerr}{Warnings and errors; 0 if none.}
\item{info}{A list includes some settings used to fit this object: \code{eps}, \code{maxit}}.
}
\description{
Trains the kernel quantile regression
}
\details{
The function implements the majorization-minimization method to solve
non-crossing kernel quantile regression.
}
\examples{
library(MASS)
lambda2 <- 1e-4
tau <- c(0.1, 0.3, 0.5, 0.7, 0.9)
lambda1 <- 10^seq(-8, 2, length.out=10)
data(GAGurine)
x <- as.matrix(GAGurine$Age)
y <- GAGurine$GAG
\donttest{fit <- nckqr(x ,y, lambda1 = lambda1 , lambda2 = lambda2, tau = tau)}
}
\keyword{quantile}
\keyword{regression}
