% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotfuns-liureg.R
\name{plot.liureg}
\alias{plot.liureg}
\title{Plot method for liureg objects}
\usage{
\method{plot}{liureg}(x, type = c("coefpath", "biasvar", "info"), ...)
}
\arguments{
\item{x}{A \code{liureg} object.}

\item{type}{What to plot on the vertical axis.  \code{coefpath} plots the
coefficient path of the Liu regression; \code{biasvar} generates a bias-variaance plot,
\code{info} plots the information criteria corresponding the regularization parameter values.}

\item{...}{Other graphical parameters to \code{plot}.}
}
\value{
No return value.
}
\description{
Plot method for liureg objects
}
\examples{
Hitters <- na.omit(Hitters)
X <- model.matrix(Salary ~ ., Hitters)[, -1]
y <- Hitters$Salary
liu.mod <- liureg(X, y, seq(0, 1, 0.01))

# Liu coefficient paths
plot(liu.mod)

# Bias-variance trade-off
plot(liu.mod, type="biasvar")
}
\seealso{
\code{\link[=liureg]{liureg()}}, \code{\link[=predict]{predict()}}, \code{\link[=summary]{summary()}}
}
\author{
Murat Genç
}
