% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/net.cluster.affiliation.R
\name{net.cluster.affiliation}
\alias{net.cluster.affiliation}
\title{Generate a cluster-affiliation graph}
\usage{
net.cluster.affiliation(
  DEG,
  community_affiliation_alpha,
  community_affiliation_lambda,
  community_affiliation_min,
  community_size_alpha,
  community_size_lambda,
  community_size_min
)
}
\arguments{
\item{DEG}{Degree sequence.}

\item{community_affiliation_alpha}{First scaling parameter of the membership distribution.}

\item{community_affiliation_lambda}{Second scaling parameter of the membership distribution.}

\item{community_affiliation_min}{Minimal membership.}

\item{community_size_alpha}{First scaling parameter of the cluster-size distribution.}

\item{community_size_lambda}{Second scaling parameter of the cluster-size distribution.}

\item{community_size_min}{Minimal size of a cluster.}
}
\value{
A list containing the nodes of the network and their respective neighbors.
}
\description{
Generate a cluster-affiliation graph.
}
\details{
The generated network has multiple (overlapping) densely-connected clusters.
}
\examples{
\dontrun{
DEG <- sample(seq(5,15),100, replace=TRUE)
x <- net.cluster.affiliation(DEG,
                             community_affiliation_alpha=1.5,
                             community_affiliation_lambda=10,
                             community_affiliation_min=1,
                             community_size_alpha=2.5,
                             community_size_lambda=40,
                             community_size_min=3)}
}
\references{
Dong X, Castro L, Shaikh N (2020). “fastnet: An R Package for Fast Simulation and Analysis of Large-Scale Social Networks.” Journal of Statistical Software, 96(7), 1-23. doi:10.18637/jss.v096.i07 (URL: https://doi.org/10.18637/jss.v096.i07)
}
\author{
Xu Dong, Nazrul Shaikh
}
