% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/net.erdos.renyi.gnp.R
\name{net.erdos.renyi.gnp}
\alias{net.erdos.renyi.gnp}
\title{Directed / Undirected Erdos-Renyi \eqn{G(n,p)} network}
\usage{
net.erdos.renyi.gnp(n, p, ncores = detectCores(), d = TRUE)
}
\arguments{
\item{n}{Number of nodes of the network.}

\item{p}{Connecting probability.}

\item{ncores}{Number of cores, by default \code{detectCores()} from \code{parallel}.}

\item{d}{A logical value determining whether is a network directed (default) or indirected.}
}
\value{
A list containing the nodes of the network and their respective neighbors.
}
\description{
Simulate a random network with \emph{n} nodes and a link connecting probability of \emph{p}, according to Edos and Renyi (1959).
}
\details{
In this (simplest) random network, each edge is formed at random with a constant probability.
When \code{d = TRUE} is a directed network.
}
\examples{
\dontrun{
x <- net.erdos.renyi.gnp(1000, 0.01)}
}
\references{
Erdos, P. and Renyi, A., On random graphs, Publicationes Mathematicae 6, 290-297 (1959).
}
\author{
Luis Castro, Xu Dong, Nazrul Shaikh.
}
