% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_nest_by.R
\name{f_nest_by}
\alias{f_nest_by}
\title{Create a subset of data for each group}
\usage{
f_nest_by(
  .data,
  ...,
  .add = FALSE,
  .order = group_by_order_default(.data),
  .by = NULL,
  .cols = NULL,
  .drop = df_group_by_drop_default(.data)
)
}
\arguments{
\item{.data}{data frame.}

\item{...}{Variables to group by.}

\item{.add}{Should groups be added to existing groups?
Default is \code{FALSE}.}

\item{.order}{Should groups be ordered? If \code{FALSE}
groups will be ordered based on first-appearance. \cr
Typically, setting order to \code{FALSE} is faster.}

\item{.by}{(Optional). A selection of columns to group by for this operation.
Columns are specified using \code{tidyselect}.}

\item{.cols}{(Optional) alternative to \code{...} that accepts
a named character vector or numeric vector.
If speed is an expensive resource, it is recommended to use this.}

\item{.drop}{Should unused factor levels be dropped? Default is \code{TRUE}.}
}
\value{
A row-wise \code{grouped_df} of the corresponding data of each group.
}
\description{
A faster \code{nest_by()}.
}
\examples{
library(dplyr)
library(fastplyr)

# Stratified linear-model example

models <- iris |>
  f_nest_by(Species) |>
  mutate(model = list(lm(Sepal.Length ~ Petal.Width + Petal.Length, data = first(data))),
         summary = list(summary(first(model))),
         r_sq = first(summary)$r.squared)
models
models$summary

# dplyr's `nest_by()` is admittedly more convenient
# as it performs a double bracket subset `[[` on list elements for you
# which we have emulated by using `first()`

# `f_nest_by()` is faster when many groups are involved

models <- iris |>
  nest_by(Species) |>
  mutate(model = list(lm(Sepal.Length ~ Petal.Width + Petal.Length, data = data)),
         summary = list(summary(model)),
         r_sq = summary$r.squared)
models$summary

models$summary[[1]]
}
