% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fbroc.paired.methods.R
\name{plot.fbroc.perf.paired}
\alias{plot.fbroc.perf.paired}
\title{Plots the difference between the bootstrapped performance estimate of the first and the second
classifier.}
\usage{
\method{plot}{fbroc.perf.paired}(x, bins = NULL, col = "white",
  fill = "lightblue", print.plot = TRUE, show.conf = TRUE,
  conf.text = TRUE, ...)
}
\arguments{
\item{x}{An object of class \code{fbroc.perf.paired}.}

\item{bins}{Number of bins for histogram. Default value depends on the number of bootstrap
values and the number of unique bootstrap performance values.}

\item{col}{Color of outline of histogram bars. Defaults to white.}

\item{fill}{Fill of histogram bars. Defaults to lightblue.}

\item{print.plot}{Logical specifying whether the plot should be printed.}

\item{show.conf}{Logical specifying whether the confidence interval
should be displayed.}

\item{conf.text}{Logical specifying whether the confidence interval limits
should also be displayed as text.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
A ggplot, so that the user can customize the plot further.
}
\description{
Given an object of class \code{fbroc.perf.paired} this function plots the difference between the 
bootstrapped performance estimate of the first and the second classifier as a histogram. 
the bootstrap as an histogram. The confidence interval is also shown by
default.
}
\examples{
data(roc.examples)
example <- boot.paired.roc(roc.examples$Cont.Pred, roc.examples$Cont.Pred.Outlier, 
                           roc.examples$True.Class, n.boot = 100)
auc.diff <- perf(example, "auc")
plot(auc.diff)
}
\seealso{
\code{\link{perf.fbroc.paired.roc}}
}
