% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_misc.R
\name{ft_encode}
\alias{ft_encode}
\title{Encode Factor Levels into Numeric Codes}
\usage{
ft_encode(factor_vec, mapping = NULL)
}
\arguments{
\item{factor_vec}{A factor vector to encode.}

\item{mapping}{An optional named vector providing the numeric code for each level.}
}
\value{
A numeric vector with encoded values.
}
\description{
Converts the levels of a factor vector into numeric codes, optionally using a provided mapping.
}
\examples{
# Example factor vector
factor_vec <- factor(c('low', 'medium', 'high', 'medium'))

# Encode without mapping
ft_encode(factor_vec)

# Encode with custom mapping
custom_mapping <- c('low' = 1, 'medium' = 2, 'high' = 3)
ft_encode(factor_vec, mapping = custom_mapping)
}
\author{
Kai Guo
}
