% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.classif.R
\name{summary.classif}
\alias{summary.classif}
\alias{print.classif}
\title{Summarizes information from kernel classification methods.}
\usage{
\method{summary}{classif}(object, ...)

\method{print}{classif}(x, digits = max(3, getOption("digits") - 3), ...)
}
\arguments{
\item{object}{Estimated by kernel classification.}

\item{\dots}{Further arguments passed to or from other methods.}

\item{x}{Estimated by kernel classification.}

\item{digits}{how many significant digits are to be used for numeric and complex x.}
}
\value{
Shows:
\itemize{ 
\item -Probability of correct classification by group \code{prob.classification}.
\item -Confusion matrix between the theoretical groups and estimated groups.
\item -Highest probability of correct classification \code{max.prob}. 
}
 If the object is returned from the function \code{\link{classif.knn}}
\itemize{ 
\item -Vector of probability of correct classification by number of neighbors \code{knn}.
\item  -Optimal number of neighbors: \code{knn.opt}. 
 }
 If the object is returned from the function: \code{\link{classif.kernel}}
\itemize{ 
\item -Vector of probability of correct classification by banwidth \code{h}.
\item  -Functional measure of closeness (optimal distance, \code{h.opt}). 
 }
}
\description{
Summary function for \code{\link{classif.knn}} or \code{\link{classif.kernel}}.
}
\details{
\code{object} from \code{\link{classif.knn}} or \code{\link{classif.kernel}}
}
\examples{
\dontrun{ 
data(phoneme)
mlearn<-phoneme[["learn"]]
glearn<-phoneme[["classlearn"]]
out=classif.knn(glearn,mlearn,knn=c(3,5,7))
summary(out)
out2=classif.kernel(glearn,mlearn,h=2^(0:5))
summary(out2)
}
}
\seealso{
See Also as: \code{\link{classif.knn}},
\code{\link{classif.kernel}} \cr and \code{\link{summary.classif}}
}
\author{
Manuel Febrero-Bande, Manuel Oviedo de la Fuente
\email{manuel.oviedo@udc.es}
}
\keyword{print}
