% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regression.R
\name{evaluation.msep}
\alias{evaluation.msep}
\title{MSEP evaluation of regression predictions}
\usage{
evaluation.msep(predictions, gt, ...)
}
\arguments{
\item{predictions}{The predictions of a regression model (\code{vector}).}

\item{gt}{The ground truth (\code{vector}).}

\item{...}{Other parameters.}
}
\value{
The evaluation of the predictions (numeric value).
}
\description{
Evaluation predictions of a regression model according to MSEP
}
\examples{
require (datasets)
data (trees)
d = splitdata (trees, 3)
model.lin = LINREG (d$train.x, d$train.y)
pred.lin = predict (model.lin, d$test.x)
evaluation.msep (pred.lin, d$test.y)
}
\seealso{
\code{\link{evaluation.r2}}, \code{\link{evaluation}}
}
