% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfee.r
\name{dfee}
\alias{dfee}
\title{Marginal First-Exposure Effects}
\usage{
dfee(model, data, at = "AE")
}
\arguments{
\item{model}{A fitted model object of class \code{"oneinfl"}.}

\item{data}{A data frame containing the variables used to fit the model.}

\item{at}{A character string or list. Specifies where the marginal FEE should be evaluated.
Options are \code{"AE"} (average), \code{"EM"} (means), or a named list of covariate values.}
}
\value{
A list with components:
\describe{
  \item{\code{dfee}}{A named numeric vector of estimated marginal first-exposure effects for each variable.}
  \item{\code{sefee}}{A numeric vector of standard errors corresponding to the marginal effects.}
  \item{\code{where}}{A character string describing the evaluation point.}
}
}
\description{
Computes marginal first-exposure effects from a fitted \code{oneinfl} model.
Dummy variables are automatically detected as those with exactly two unique values
in the data, and corresponding marginal effects are instead calculated by differencing
the FEE between both values of the dummy.
}
\details{
The marginal effects can be evaluated in three ways, determined by the \code{at} argument:
\itemize{
  \item \code{"AE"}: Average over all data points (default).
  \item \code{"EM"}: Evaluate at the sample means of the covariates.
  \item \code{list}: Evaluate at a user-specified set of covariate values.
}
}
\examples{
df <- data.frame(x = runif(10,0,10), d = sample(c(0,1), 10, replace=TRUE), y = rpois(10, 3) + 1)
model <- oneinfl::oneinfl(formula = y ~ x + d | x + d, df = df, dist = "Poisson")
dfee(model, data = df)

}
\seealso{
\code{\link{fee}}, \code{\link{dfee_pois}}, \code{\link{dfee_nb}}
}
