% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fermicatsR.R
\docType{data}
\name{FGL0}
\alias{FGL0}
\title{0FGL Catalog (Fermi Large Area Telescope Bright Gamma-ray Source List)}
\format{A data frame with 21 variables on 205 gamma-ray sources.}
\source{
\url{http://heasarc.gsfc.nasa.gov/W3Browse/fermi/fermilbsl.html}
}
\usage{
FGL0
}
\description{
Fermi Large Area Telescope Bright Gamma-ray Source List (0FGL).
Abdo, A. A. et al., The Astrophysical Journal Supplement Series, 183, 46 (2009).
}
\details{
FITS Filename: gll_psc3month_BSL_v2.fit
}
\section{Fields}{
 
\describe{
\item{\code{Source_Name}}{0FGL JHHMM.m+DDMM, constructed according to IAU Specifications for Nomenclature; 
m is decimal minutes of R.A.; in the name R.A. and decl. are truncated at 0.1 decimal minutes and 1' , respectively}
\item{RA}{Right Ascension, J2000, deg, 3 decimal places}
\item{DEC}{Declination, J2000, deg, 3 decimal places}
\item{GLON}{Galactic Longitude, deg, 3 decimal places}
\item{GLAT}{Galactic Latitude, deg, 3 decimal places}
\item{Conf_95_Radius}{Radius of 95\% confidence region, deg, 3 decimal places}
\item{Sqrt_TS}{Square root of likelihood TS from 200 MeV - 100 GeV analysis, used for the TS > 100 cut, 1 decimal place}
\item{Flux_100_1000}{Flux 100 MeV to 1 GeV (i.e., log_10 E = 2-3), 10^{-8} cm^{-2} s^{-1}, 2 decimal places}
\item{Unc_Flux100_1000}{1 sigma uncertainty on F_23, same units and precision. A 0 in this column indicates that the entry in the F_23 flux column is an upper limit.}
\item{Flux1000_100000}{Flux for 1 GeV to 100 GeV (i.e., log_10 E = 3-5), 10^{-8} cm^{-2} s^{-1}, 2 decimal places}
\item{Unc_Flux1000_100000}{1 sigma uncertainty on F_35, same units and precision.}
\item{Variability_Flag}{T indicates < 1\% chance of being a steady source on a weekly timescale}
\item{Sqrt_TS23}{Square root of TS for the 100 MeV to 1 GeV range, 1 decimal place}
\item{Sqrt_TS35}{Square root of TS for the 1 GeV to 100 GeV range, 1 decimal place}
\item{ASSOC_GAM1}{Identification or positional associations with 3EG, EGR, or AGILE sources} 
\item{ASSOC_GAM2}{Identification or positional associations with 3EG, EGR, or AGILE sources}
\item{ASSOC_GAM3}{Identification or positional associations with 3EG, EGR, or AGILE sources}
\item{CLASS1}{Class designation for associated source. Capital letters indicate firm identifications; 
lower-case letters indicate associations: Pulsar (PSR), Pulsar wind nebula (pwn), High-mass X-ray binary (hxb),
BL Lac type of blazar (bzb), FSRQ type of blazar (bzq), Uncertain type of blazar (bzu), Radio galaxy (rdg),
Globular cluster (glb), Special case - potential association with SNR or PWN (x), Unassociated (  ).}
\item{CLASS2}{2nd class designation for associated source}
\item{ASSOC1}{Name of identified or likely associated source}
\item{ASSOC2}{Alternate name of identified or likely associated source}
}
}
\keyword{datasets}

