% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fermicatsR.R
\docType{data}
\name{LAC3_LO}
\alias{LAC3_LO}
\title{3LAC_LO (Third Catalog of Active Galactic Nuclei Detected by the Fermi Large Area Telescope - Low Galactic Latitude)}
\format{A data frame with 20 variables on 182 gamma-ray sources.}
\source{
\url{http://adsabs.harvard.edu/abs/2015ApJ...810...14A}
}
\usage{
LAC3_LO
}
\description{
Third Catalog of Active Galactic Nuclei (3LAC).
Ackermann, M. et al., The Astrophysical Journal, 810, 14 (2015).
}
\details{
Low Galactic Latitude (|GLAT| < 10 deg.) Sources.
}
\section{Fields}{
 
\describe{
\item{GLON}{Galactic Longitude, degrees}
\item{GLAT}{Galactic Latitude, degrees}
\item{ASSOC_3FGL}{3FGL Source Name (JHHMM.m+DDMM)}
\item{VHE}{Display this very-high-energy AGN data (table10)}
\item{CName}{Name of the counterpart source}
\item{RAJ2000}{Radio counterpart right Ascension (J2000)}
\item{DEJ2000}{Radio counterpart declination (J2000)}
\item{Sep}{Angular separation with counterpart source, deg.}
\item{PosErr}{95\% error radius, deg.}
\item{SpCl}{Optical class (G1)}
\item{SEDCl}{SED class}
\item{lognu}{Log frequency of observer-frame position of synchrotron peak (NupSyn-Meas)}
\item{lognuRf}{Log frequency of rest-frame position of synchrotron peak (NupSyn-Rf)}
\item{z}{Redshift}
\item{Prob}{Bayesian probability}
\item{LR.RG}{Likelihood Ratio reliability for Radio-gamma-ray association}
\item{FRad}{Radio flux}
\item{n_FRad}{Flag on FRad}
\item{FX}{X-ray flux; units of 1e-13erg/cm2/s}
\item{LR.XG}{Likelihood Ratio reliability for X-ray-gamma-ray association}
}
}
\keyword{datasets}

