% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal.R
\name{.fft}
\alias{.fft}
\title{Compute the Fast Fourier Transform (FFT) of a Vector}
\usage{
.fft(x, norm = FALSE)
}
\arguments{
\item{x}{A numeric vector representing the input signal to transform.}

\item{norm}{A logical value indicating whether to normalize the FFT output
by dividing it by the length of the input vector. Default is \code{FALSE}.}
}
\value{
A complex vector representing the FFT of the input signal.
}
\description{
Computes the Fast Fourier Transform (FFT) of a numeric vector.
Optionally, normalizes the result by dividing it by the length of the input vector.
}
\details{
This function wraps around the base R \code{stats::fft} function and provides an
option for normalization.
}
\seealso{
\code{\link[stats:fft]{stats::fft()}}
}
\keyword{internal}
