% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fhir_table_description.R
\docType{class}
\name{fhir_table_description-class}
\alias{fhir_table_description-class}
\title{A S4 class describing the form of a table produced by \code{\link[=fhir_crack]{fhir_crack()}}}
\description{
A \code{fhir_table_description} holds the information \code{\link[=fhir_crack]{fhir_crack()}} needs to flatten (aka crack) FHIR resources from a FHIR bundle and
is created with its constructor function \code{\link[=fhir_table_description]{fhir_table_description()}}.
Each \code{fhir_table_description} describes a table for a specific resource type as \code{\link[=fhir_crack]{fhir_crack()}} will create one data.frame/data.table
per resource type. See Details.
}
\details{
A \code{fhir_table_description} consists of
the following elements:
\itemize{
\item The resource element: Defines the resource type (e.g. \code{Patient} or \code{Observation}). See \code{\link[=fhir_resource_type]{fhir_resource_type()}}.
\item The cols element: Contains the column names and XPath expressions defining the columns to extract.
If this element is empty, \code{\link[=fhir_crack]{fhir_crack()}} will extract all available elements of the resource and name the
columns automatically. See \code{\link[=fhir_columns]{fhir_columns()}}.
\item The sep element: A character of length one containing the separator string used for separating multiple entries in cells.
\item The brackets element: A character of length one or two used for the indices of multiple entries. The first one is the opening bracket
and the second one the closing bracket. Vectors of length one will be recycled.
Defaults to \code{character(0)}, i.e. no brackets, meaning that multiple entries won't be indexed.
\item The rm_empty_cols element: A logical of length one indicating whether empty columns should be removed in the resulting table or not. Defaults to \code{FALSE}.
\item The format element: A character of length one indicating whether the resulting table should be cracked to a \code{wide} or \code{compact} format.
\code{wide} means multiple entries will be distributed over several columns with indexed names. \code{compact} means multiple entries will be pasted into one cell/column separated by \code{sep} .
Defaults to \code{compact}.
\item The keep_attr element: A logical of length one indicating whether the attribute name of the respective element (\verb{@value} in most cases)
should be attached to the name of the variable in the resulting table. Defaults to \code{FALSE}.
}

A full \code{fhir_table_description} looks for example like this:

\if{html}{\out{<div class="sourceCode">}}\preformatted{fhir_resource_type: Patient

fhir_columns:
column name | xpath expression
------------------------
name        | name/family
gender      | gender
id          | id

sep:           ':::'
brackets:      '[', ']'
rm_empty_cols: FALSE
format:        'compact'
keep_attr:     FALSE
}\if{html}{\out{</div>}}
}
\section{Slots}{

\describe{
\item{\code{resource}}{An object of class \linkS4class{fhir_resource_type} defining the resource type that
should be extracted.}

\item{\code{cols}}{An object of class \linkS4class{fhir_columns} describing which columns should be created and how.
If this is an empty \linkS4class{fhir_columns} object, the call to \code{\link[=fhir_crack]{fhir_crack()}} will extract all available
elements and put them in automatically named columns.}

\item{\code{sep}}{A character of length one containing the separator string used for separating multiple entries in cells when \code{format = "compact"}.
ignored when \code{format = "wide"}.}

\item{\code{brackets}}{A character of length one or two used for the indices of multiple entries. The first one is the opening bracket
and the second one the closing bracket. Vectors of length one will be recycled.
Defaults to \code{character(0)}, i.e. no brackets, meaning that multiple entries won't be indexed.}

\item{\code{rm_empty_cols}}{A logical of length one indicating whether empty columns should be removed from the resulting table or not. Defaults to FALSE.}

\item{\code{format}}{A character of length one indicating whether the resulting table should be cracked to a \code{wide} or \code{compact} format.
\code{wide} means multiple entries will be distributed over several columns with indexed names. \code{compact} means multiple entries will be pasted into one cell/column separated by \code{sep} .
Defaults to \code{compact}.}

\item{\code{keep_attr}}{A logical of length one indicating whether the attribute name of the respective element (\verb{@value} in most cases)
should be attached to the name of the variable in the resulting table. Defaults to \code{FALSE}}
}}

\seealso{
\code{\link[=fhir_resource_type]{fhir_resource_type()}},\code{\link[=fhir_columns]{fhir_columns()}}, \code{\link[=fhir_design]{fhir_design()}}, \code{\link[=fhir_crack]{fhir_crack()}}
}
