#' Data from Gevers et al. (2014)
#' 
#' OTU data and metadata for 1,359 samples in a Crohn's disease study
#' 
#' Study is described here: \url{https://pubmed.ncbi.nlm.nih.gov/24629344/}.
#' Data was obtained from \url{https://github.com/twbattaglia/MicrobeDS}.
#' 
#' @docType data
#' @name RISK_CCFA
#' @usage data(RISK_CCFA)
#' @format An otu table, sample data table, and taxonomy table.
#' @references Gevers D, et al. The treatment-naive microbiome in new-onset Crohn's disease. Cell Host Microbe. 2014 Mar 12;15(3):382-392. doi: 10.1016/j.chom.2014.02.005. PMID: 24629344; PMCID: PMC4059512.
NULL

#' Data from Gevers et al. (2014)
#' 
#' OTU data and metadata for 1,359 samples in a Crohn's disease study
#' 
#' Study is described here: \url{https://pubmed.ncbi.nlm.nih.gov/24629344/}.
#' Data was obtained from \url{https://github.com/twbattaglia/MicrobeDS}.
#' 
#' @docType data
#' @name RISK_CCFA_otu
#' @usage data(RISK_CCFA)
#' @format A matrix otu table.
#' @references Gevers D, et al. The treatment-naive microbiome in new-onset Crohn's disease. Cell Host Microbe. 2014 Mar 12;15(3):382-392. doi: 10.1016/j.chom.2014.02.005. PMID: 24629344; PMCID: PMC4059512.
NULL

#' Data from Gevers et al. (2014)
#' 
#' OTU data and metadata for 1,359 samples in a Crohn's disease study
#' 
#' Study is described here: \url{https://pubmed.ncbi.nlm.nih.gov/24629344/}.
#' Data was obtained from \url{https://github.com/twbattaglia/MicrobeDS}.
#' 
#' @docType data
#' @name RISK_CCFA_sam
#' @usage data(RISK_CCFA)
#' @format A sample data table.
#' @references Gevers D, et al. The treatment-naive microbiome in new-onset Crohn's disease. Cell Host Microbe. 2014 Mar 12;15(3):382-392. doi: 10.1016/j.chom.2014.02.005. PMID: 24629344; PMCID: PMC4059512.
NULL


#' Data from Gevers et al. (2014)
#' 
#' OTU data and metadata for 1,359 samples in a Crohn's disease study
#' 
#' Study is described here: \url{https://pubmed.ncbi.nlm.nih.gov/24629344/}.
#' Data was obtained from \url{https://github.com/twbattaglia/MicrobeDS}.
#' 
#' @docType data
#' @name RISK_CCFA_tax
#' @usage data(RISK_CCFA)
#' @format A taxonomy table.
#' @references Gevers D, et al. The treatment-naive microbiome in new-onset Crohn's disease. Cell Host Microbe. 2014 Mar 12;15(3):382-392. doi: 10.1016/j.chom.2014.02.005. PMID: 24629344; PMCID: PMC4059512.
NULL
