% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fidofit_methods.R
\name{predict.pibblefit}
\alias{predict.pibblefit}
\title{Predict response from new data}
\usage{
\method{predict}{pibblefit}(
  object,
  newdata = NULL,
  response = "LambdaX",
  size = NULL,
  use_names = TRUE,
  summary = FALSE,
  iter = NULL,
  from_scratch = FALSE,
  ...
)
}
\arguments{
\item{object}{An object of class pibblefit}

\item{newdata}{An optional matrix for which to evaluate predictions. If NULL
(default), the original data of the model is used.}

\item{response}{Options = "LambdaX":Mean of regression, "Eta", "Y": counts}

\item{size}{the number of counts per sample if response="Y" (as vector or matrix), 
default if newdata=NULL and response="Y" is to use colsums of m$Y. Otherwise
uses median colsums of m$Y as default. If passed as a matrix should have dimensions
ncol(newdata) x iter.}

\item{use_names}{if TRUE apply names to output}

\item{summary}{if TRUE, posterior summary of predictions are returned rather
than samples}

\item{iter}{number of iterations to return if NULL uses object$iter}

\item{from_scratch}{should predictions of Y come from fitted Eta or from 
predictions of Eta from posterior of Lambda? (default: false)}

\item{...}{other arguments passed to summarise_posterior}
}
\value{
(if summary==FALSE) array D x N x iter; (if summary==TRUE) 
tibble with calculated posterior summaries
}
\description{
Predict response from new data
}
\details{
currently only implemented for pibblefit objects in coord_system "default"
"alr", or "ilr".
}
\examples{
sim <- pibble_sim()
fit <- pibble(sim$Y, sim$X)
predict(fit)[,,1:2] # just show 2 samples
}
