% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/figma.R
\name{get_figma_page}
\alias{get_figma_page}
\title{Get data of a specific canvas/page in a Figma File from the API}
\usage{
get_figma_page(
  file_key,
  token,
  node_ids,
  geometry = FALSE,
  .output_format = "response",
  ...
)
}
\arguments{
\item{file_key}{A string with the key of the Figma File you want to get;}

\item{token}{A string with your personal Figma token to authenticate in the API;}

\item{node_ids}{A string with the node ID (or a vector of strings with node IDs);}

\item{geometry}{A boolean value indicating if you want to export vector data.
Defaults to FALSE;}

\item{.output_format}{The output format. Options are \code{"response",
"figma_document", "tibble"}. Defaults to \code{"response"};}

\item{...}{Further arguments that are passed to \code{parse_response_object()};}
}
\value{
By default, \code{get_figma_page()} do not parse the output from
the API, and returns the raw \code{response} object
produced by the \code{httr} HTTP methods (e.g. \code{httr::GET()}).

But you can change this behavior with \code{.output_format} argument. With
\code{.output_format = "tibble"}, a \code{tibble::tibble()} object
is returned. With \code{.output_format = "figma_document"}, a object of
class \code{figma_document} is returned (See Details
section for more information).
}
\description{
This function uses the \code{/v1/files/} endpoint of Figma API
to get the data of an specific canvas/page (or a set of canvas/pages) from a Figma file,
and fit it into a R object.
}
\details{
With `get_figma_file()` you get data of all objects in all canvas/pages of your Figma file.
But with `get_figma_page()` you get data of all objects drawn in a specific set of canvas/pages
of your Figma file.

Every canvas/page in a Figma file, is identified by a node ID. You can easily get this ID
from the URL that appears in your browser when you access this canvas/page on the
Figma platform (See \code{vignette("figma")} for more details).

After you collected this node ID, give it to \code{node_id} argument as a string. If
you want to collect data from more than one canvas/page of your Figma file, give a vector
of node IDs to \code{node_id} argument.
}
\section{Be aware of possible HTTP errors}{

To get the data of your Figma file, the functions from \code{figma} package make a HTTP
request to the Figma API. But this request can fail for a number of reasons, and if this
does happen, \code{get_figma_page()} will use \code{report_http_error()} to raise an error
and report to the user, what kind of error message the Figma API returned.
See \code{vignette("http-errors")} for more details.
}

\examples{
\dontrun{
library(figma)
file_key <- "hch8YlkgaUIZ9raDzjPvCz"
token <- "my figma token secret ... "
node_id <- "0\%3A1"
result <- figma::get_figma_page(
  file_key, token, node_id
)
}
}
