% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filters.R
\name{add_filter}
\alias{add_filter}
\title{Add a New Filter Definition}
\usage{
add_filter(
  id,
  title,
  target,
  condition,
  character_only = FALSE,
  overwrite = FALSE
)
}
\arguments{
\item{id}{\code{character} The id or name of this filter, e.g. \code{"SE"}.}

\item{title}{\code{character} The title of the filter}

\item{target}{\code{character} The target dataset of the filter}

\item{condition}{The filter condition}

\item{character_only}{\code{logical}. Is \code{condition} a string? Defaults to \code{FALSE}.}

\item{overwrite}{\code{logical} Should existing filters be overwritten? Defaults to \code{FALSE}.}
}
\value{
The function returns a \code{list} of \code{title}, \code{target} and \code{condition}
invisibly
}
\description{
Add a new filter definition or overwrite an existing one
}
\examples{
add_filter(
  id = "CTC5",
  title = "Grade 5 Adverse Event",
  target = "ADAE",
  condition = AETOXGR == "5"
)

add_filter(
  id = "CTC4",
  title = "Grade 4 Adverse Event",
  target = "ADAE",
  condition = "AETOXGR == '4'",
  character_only = TRUE
)

add_filter(
  id = "IT",
  title = "ITT Population",
  target = "ADSL",
  condition = ITTFL == "Y",
  overwrite = TRUE
)

add_filter(
  id = "5PER",
  title = "Adverse Events with a Difference of at Least 5\% between Treatment Arms",
  target = "adae",
  condition = 1 == 1,
  overwrite = TRUE
)

}
\author{
Thomas Neitmann (\code{neitmant})
}
