% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{virtual_mixture}
\alias{virtual_mixture}
\title{Create a virtual sediment mixture}
\usage{
virtual_mixture(data, weights)
}
\arguments{
\item{data}{A data frame containing the characteristics of the sediment sources.
Users should ensure their data is in a valid format by using the `check_database()`
function before running this function.}

\item{weights}{A numeric vector representing the proportional contributions (apportionment
values) of each source to the virtual mixture. The order of weights in the vector must
correspond to the order of sources in the `data` frame. The sum of `weights` should
ideally equal 1.}
}
\value{
A data frame representing the virtual mixture. This data frame will have the
  same structure as a single row for a mixture in your input `data`, but with tracer
  values calculated based on the provided `weights`.
}
\description{
This function generates a virtual sediment mixture based on the
characteristics of existing sediment sources and a set of user-defined apportionment
weights. It effectively simulates a mixture with known source contributions.
}
\details{
A virtual mixture is a hypothetical sediment sample created by mathematically
combining the tracer characteristics of known sources according to specified proportions (`weights`).
This is a powerful tool in sediment fingerprinting for:
\itemize{
  \item **Consistency Checks**: Comparing observed mixture data against a virtual mixture
    can help assess the consistency of a dataset or the validity of an unmixing solution.
  \item **Scenario Testing**: Simulating mixtures under different hypothetical source contributions
    to understand how changes might affect sediment composition.
  \item **Model Validation**: Generating known virtual mixtures to test the accuracy and
    performance of unmixing models.
}
The function calculates the tracer values for the virtual mixture by taking the weighted
average of the corresponding tracer values from each source.
}
