% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finnishgrid.R
\name{ffr_price}
\alias{ffr_price}
\title{Fast Frequency Reserve FFR, price}
\usage{
ffr_price(start_time_utc = NA, end_time_utc = NA, user_key = NA)
}
\arguments{
\item{start_time_utc}{Start time in UTC. Character array YYYY-MM-ddTHH:mm:ss.sssZ}

\item{end_time_utc}{End time in UTC. Character array YYYY-MM-ddTHH:mm:ss.sssZ}

\item{user_key}{Character array holding API-key.
Free from https://data.fingrid.fi/en/instructions}
}
\value{
A data frame object with time series data having period 1 h and unit type €/MW.
}
\description{
The price of procured Fast Frequency Reserve (FFR) (/MW). The price will be published 22:00 (EET) on previous evening. The price is determined by the price of the most expensive procured bid (marginal pricing).The Fast Frequency Reserve (FFR) is procured to handle low-inertia situations. The needed volume of Fast Frequency Reserve depends on the amount of inertia in the power system and the size of the reference incident.
}
\examples{
\dontrun{
library(finnishgrid)
start = "2024-06-01T00:00:00.000Z"  # UTC
end = "2024-06-03T00:00:00.000Z"    # UTC
key = "MY_SUPER_SECRET"
df <- ffr_price(start_time_utc = start,
         end_time_utc = end,
         user_key = key)
summary(df)
}
}
\seealso{
https://data.fingrid.fi/en/datasets/277
}
