% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-email-password.R
\name{FirebaseEmailPassword}
\alias{FirebaseEmailPassword}
\title{Email & Password}
\value{
An object of class \code{FirebaseEmailPassword}.
}
\description{
Manage users using email and password.
}
\note{
Also signs in the user if successful.
}
\examples{
library(shiny)
library(firebase)

# modals
register <- modalDialog(
  title = "Register",
  textInput("email_create", "Your email"),
  passwordInput("password_create", "Your password"),
  footer = actionButton("create", "Register")
)

sign_in <- modalDialog(
  title = "Sign in",
  textInput("email_signin", "Your email"),
  passwordInput("password_signin", "Your password"),
  footer = actionButton("signin", "Sign in")
)

ui <- fluidPage(
  useFirebase(), # import dependencies
  actionButton("register_modal", "Register"),
  actionButton("signin_modal", "Signin"),
  plotOutput("plot")
)

server <- function(input, output){

  f <- FirebaseEmailPassword$new()

  # open modals
  observeEvent(input$register_modal, {
    showModal(register)
  })

  observeEvent(input$signin_modal, {
    showModal(sign_in)
  })

  # create the user
  observeEvent(input$create, {
    f$create(input$email_create, input$password_create)
  })

  # check if creation sucessful
  observeEvent(f$get_created(), {
    created <- f$get_created()
    
    if(created$success){
      removeModal()
      showNotification("Account created!", type = "message")
    } else {
      showNotification("Error!", type = "error")
    }

    # print results to the console
    print(created)
  })

  observeEvent(input$signin, {
    removeModal()
    f$sign_in(input$email_signin, input$password_signin)
  })

  output$plot <- renderPlot({
    f$req_sign_in()
    plot(cars)
  })

}

\dontrun{shinyApp(ui, server)}

}
\section{Super classes}{
\code{\link[firebase:Firebase]{firebase::Firebase}} -> \code{\link[firebase:FirebaseAuth]{firebase::FirebaseAuth}} -> \code{FirebaseEmailPassword}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{created}}{Results of account creation}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-FirebaseEmailPassword-new}{\code{FirebaseEmailPassword$new()}}
\item \href{#method-FirebaseEmailPassword-create}{\code{FirebaseEmailPassword$create()}}
\item \href{#method-FirebaseEmailPassword-sign_in}{\code{FirebaseEmailPassword$sign_in()}}
\item \href{#method-FirebaseEmailPassword-get_created}{\code{FirebaseEmailPassword$get_created()}}
\item \href{#method-FirebaseEmailPassword-reset_password}{\code{FirebaseEmailPassword$reset_password()}}
\item \href{#method-FirebaseEmailPassword-get_reset}{\code{FirebaseEmailPassword$get_reset()}}
\item \href{#method-FirebaseEmailPassword-send_verification_email}{\code{FirebaseEmailPassword$send_verification_email()}}
\item \href{#method-FirebaseEmailPassword-get_verification_email}{\code{FirebaseEmailPassword$get_verification_email()}}
\item \href{#method-FirebaseEmailPassword-set_password}{\code{FirebaseEmailPassword$set_password()}}
\item \href{#method-FirebaseEmailPassword-get_password}{\code{FirebaseEmailPassword$get_password()}}
\item \href{#method-FirebaseEmailPassword-re_authenticate}{\code{FirebaseEmailPassword$re_authenticate()}}
\item \href{#method-FirebaseEmailPassword-get_re_authenticated}{\code{FirebaseEmailPassword$get_re_authenticated()}}
\item \href{#method-FirebaseEmailPassword-clone}{\code{FirebaseEmailPassword$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="firebase" data-topic="Firebase" data-id="expose_app"><a href='../../firebase/html/Firebase.html#method-Firebase-expose_app'><code>firebase::Firebase$expose_app()</code></a></span></li>
<li><span class="pkg-link" data-pkg="firebase" data-topic="FirebaseAuth" data-id="clear"><a href='../../firebase/html/FirebaseAuth.html#method-FirebaseAuth-clear'><code>firebase::FirebaseAuth$clear()</code></a></span></li>
<li><span class="pkg-link" data-pkg="firebase" data-topic="FirebaseAuth" data-id="delete_user"><a href='../../firebase/html/FirebaseAuth.html#method-FirebaseAuth-delete_user'><code>firebase::FirebaseAuth$delete_user()</code></a></span></li>
<li><span class="pkg-link" data-pkg="firebase" data-topic="FirebaseAuth" data-id="expose_auth"><a href='../../firebase/html/FirebaseAuth.html#method-FirebaseAuth-expose_auth'><code>firebase::FirebaseAuth$expose_auth()</code></a></span></li>
<li><span class="pkg-link" data-pkg="firebase" data-topic="FirebaseAuth" data-id="get_access_token"><a href='../../firebase/html/FirebaseAuth.html#method-FirebaseAuth-get_access_token'><code>firebase::FirebaseAuth$get_access_token()</code></a></span></li>
<li><span class="pkg-link" data-pkg="firebase" data-topic="FirebaseAuth" data-id="get_delete_user"><a href='../../firebase/html/FirebaseAuth.html#method-FirebaseAuth-get_delete_user'><code>firebase::FirebaseAuth$get_delete_user()</code></a></span></li>
<li><span class="pkg-link" data-pkg="firebase" data-topic="FirebaseAuth" data-id="get_id_token"><a href='../../firebase/html/FirebaseAuth.html#method-FirebaseAuth-get_id_token'><code>firebase::FirebaseAuth$get_id_token()</code></a></span></li>
<li><span class="pkg-link" data-pkg="firebase" data-topic="FirebaseAuth" data-id="get_sign_out"><a href='../../firebase/html/FirebaseAuth.html#method-FirebaseAuth-get_sign_out'><code>firebase::FirebaseAuth$get_sign_out()</code></a></span></li>
<li><span class="pkg-link" data-pkg="firebase" data-topic="FirebaseAuth" data-id="get_signed_in"><a href='../../firebase/html/FirebaseAuth.html#method-FirebaseAuth-get_signed_in'><code>firebase::FirebaseAuth$get_signed_in()</code></a></span></li>
<li><span class="pkg-link" data-pkg="firebase" data-topic="FirebaseAuth" data-id="get_signed_up"><a href='../../firebase/html/FirebaseAuth.html#method-FirebaseAuth-get_signed_up'><code>firebase::FirebaseAuth$get_signed_up()</code></a></span></li>
<li><span class="pkg-link" data-pkg="firebase" data-topic="FirebaseAuth" data-id="is_signed_in"><a href='../../firebase/html/FirebaseAuth.html#method-FirebaseAuth-is_signed_in'><code>firebase::FirebaseAuth$is_signed_in()</code></a></span></li>
<li><span class="pkg-link" data-pkg="firebase" data-topic="FirebaseAuth" data-id="print"><a href='../../firebase/html/FirebaseAuth.html#method-FirebaseAuth-print'><code>firebase::FirebaseAuth$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="firebase" data-topic="FirebaseAuth" data-id="req_sign_in"><a href='../../firebase/html/FirebaseAuth.html#method-FirebaseAuth-req_sign_in'><code>firebase::FirebaseAuth$req_sign_in()</code></a></span></li>
<li><span class="pkg-link" data-pkg="firebase" data-topic="FirebaseAuth" data-id="req_sign_out"><a href='../../firebase/html/FirebaseAuth.html#method-FirebaseAuth-req_sign_out'><code>firebase::FirebaseAuth$req_sign_out()</code></a></span></li>
<li><span class="pkg-link" data-pkg="firebase" data-topic="FirebaseAuth" data-id="request_id_token"><a href='../../firebase/html/FirebaseAuth.html#method-FirebaseAuth-request_id_token'><code>firebase::FirebaseAuth$request_id_token()</code></a></span></li>
<li><span class="pkg-link" data-pkg="firebase" data-topic="FirebaseAuth" data-id="set_language_code"><a href='../../firebase/html/FirebaseAuth.html#method-FirebaseAuth-set_language_code'><code>firebase::FirebaseAuth$set_language_code()</code></a></span></li>
<li><span class="pkg-link" data-pkg="firebase" data-topic="FirebaseAuth" data-id="sign_out"><a href='../../firebase/html/FirebaseAuth.html#method-FirebaseAuth-sign_out'><code>firebase::FirebaseAuth$sign_out()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FirebaseEmailPassword-new"></a>}}
\if{latex}{\out{\hypertarget{method-FirebaseEmailPassword-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FirebaseEmailPassword$new(
  persistence = c("session", "local", "memory"),
  config_path = "firebase.rds",
  language_code = NULL,
  session = shiny::getDefaultReactiveDomain()
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{persistence}}{How the auth should persit: \code{none}, the user has to sign in at every visit,
\code{session} will only persist in current tab, \code{local} persist even when window is closed.}

\item{\code{config_path}}{Path to the configuration file as created by \code{\link{firebase_config}}.}

\item{\code{language_code}}{Sets the language to use for the UI.
Supported languages are listed \href{https://github.com/firebase/firebaseui-web/blob/master/LANGUAGES.md}{here}.
Set to \code{browser} to use the default browser language of the user.}

\item{\code{session}}{A valid shiny session.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Initialiases Firebase Email Password

Initialises the Firebase application client-side.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FirebaseEmailPassword-create"></a>}}
\if{latex}{\out{\hypertarget{method-FirebaseEmailPassword-create}{}}}
\subsection{Method \code{create()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FirebaseEmailPassword$create(email, password)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{email, password}}{Credentials as entered by the user.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Create an account
}

\subsection{Returns}{
self
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FirebaseEmailPassword-sign_in"></a>}}
\if{latex}{\out{\hypertarget{method-FirebaseEmailPassword-sign_in}{}}}
\subsection{Method \code{sign_in()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FirebaseEmailPassword$sign_in(email, password)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{email, password}}{Credentials as entered by the user.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Sign in with email
}

\subsection{Returns}{
\code{NULL} if successful, the error otherwise.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FirebaseEmailPassword-get_created"></a>}}
\if{latex}{\out{\hypertarget{method-FirebaseEmailPassword-get_created}{}}}
\subsection{Method \code{get_created()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FirebaseEmailPassword$get_created()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Get account creation results
}

\subsection{Returns}{
A list of length 2 containing \code{success} a boolean
indicating wherther creation was successful and \code{response}
containing the result of account creation or the error if failed.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FirebaseEmailPassword-reset_password"></a>}}
\if{latex}{\out{\hypertarget{method-FirebaseEmailPassword-reset_password}{}}}
\subsection{Method \code{reset_password()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FirebaseEmailPassword$reset_password(email = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{email}}{Email to send reset link to, if missing looks for current logged in user's email.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Reset user password
}

\subsection{Returns}{
self
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FirebaseEmailPassword-get_reset"></a>}}
\if{latex}{\out{\hypertarget{method-FirebaseEmailPassword-get_reset}{}}}
\subsection{Method \code{get_reset()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FirebaseEmailPassword$get_reset()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Get whether password reset email was successfully sent
}

\subsection{Returns}{
A list of length 2 containing \code{success} a boolean
indicating whether email reset was successful and \code{response}
containing \code{successful} or the error.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FirebaseEmailPassword-send_verification_email"></a>}}
\if{latex}{\out{\hypertarget{method-FirebaseEmailPassword-send_verification_email}{}}}
\subsection{Method \code{send_verification_email()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FirebaseEmailPassword$send_verification_email()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Send the user a verification email
}

\subsection{Returns}{
self
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FirebaseEmailPassword-get_verification_email"></a>}}
\if{latex}{\out{\hypertarget{method-FirebaseEmailPassword-get_verification_email}{}}}
\subsection{Method \code{get_verification_email()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FirebaseEmailPassword$get_verification_email()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Get result of verification email sending procedure
}

\subsection{Returns}{
A list of length 2 containing \code{success} a boolean
indicating whether email verification was successfully sent and \code{response}
containing \code{successful} or the error.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FirebaseEmailPassword-set_password"></a>}}
\if{latex}{\out{\hypertarget{method-FirebaseEmailPassword-set_password}{}}}
\subsection{Method \code{set_password()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FirebaseEmailPassword$set_password(password)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{password}}{The authenticated user password, the user should be prompted
to enter it.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Set user password

Useful to provide ability to change password.
}

\subsection{Returns}{
self
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FirebaseEmailPassword-get_password"></a>}}
\if{latex}{\out{\hypertarget{method-FirebaseEmailPassword-get_password}{}}}
\subsection{Method \code{get_password()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FirebaseEmailPassword$get_password()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Get response from set_password
}

\subsection{Returns}{
A list of length 2 containing \code{success} a boolean
indicating whether setting password was successfully set and \code{response}
containing \code{successful} as string or the error.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FirebaseEmailPassword-re_authenticate"></a>}}
\if{latex}{\out{\hypertarget{method-FirebaseEmailPassword-re_authenticate}{}}}
\subsection{Method \code{re_authenticate()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FirebaseEmailPassword$re_authenticate(password)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{password}}{The authenticated user password, the user should be prompted
to enter it.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Re-authenticate the user.

Some security-sensitive actions—such as deleting an account, setting a
primary email address, and changing a password—require that the user has
recently signed in. If you perform one of these actions, and the user signed
in too long ago, the action fails with an error.
}

\subsection{Returns}{
self
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FirebaseEmailPassword-get_re_authenticated"></a>}}
\if{latex}{\out{\hypertarget{method-FirebaseEmailPassword-get_re_authenticated}{}}}
\subsection{Method \code{get_re_authenticated()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FirebaseEmailPassword$get_re_authenticated()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Get response from re_authenticate
}

\subsection{Returns}{
A list of length 2 containing \code{success} a boolean
indicating whether re-authentication was successful and \code{response}
containing \code{successful} as string or the error.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FirebaseEmailPassword-clone"></a>}}
\if{latex}{\out{\hypertarget{method-FirebaseEmailPassword-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FirebaseEmailPassword$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
