% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fireChart_function.R
\name{fireChart}
\alias{fireChart}
\title{Fire Characteristics Chart}
\usage{
fireChart(name, hpua, ros)
}
\arguments{
\item{name}{a character vector identifying names of predictions}

\item{hpua}{a numeric vector of heat per unit area (kJ/m2)}

\item{ros}{a numeric vector of rate of spread (m/min)}
}
\value{
an object of class ggplot
}
\description{
Visualization of predicted fire behavior using the Fire Characteristics Chart.
}
\examples{
fc = fireChart('fire',hpua = 15000, ros = 50)
print(fc)
}
\references{
Andrews, P.L. & Rothermel, R.C. 1982. Charts for interpreting wildland fire behavior characteristics.
\emph{INT-GTR-131}. USDA Forest Service Intermountain Forest & Range Experimental Station.
}
\author{
Justin P Ziegler, \email{justin.ziegler@colostate.edu}
}
